/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.opencl;

import java.util.ArrayList;
import java.util.List;
import org.encog.engine.EncogEngineError;
import org.encog.engine.opencl.EncogCLDevice;
import org.encog.engine.opencl.EncogCLPlatform;
import org.encog.engine.opencl.exceptions.MissingOpenCLAdapterError;
import org.jocl.CL;
import org.jocl.cl_platform_id;

public class EncogCL {
    private final List<EncogCLPlatform> platforms = new ArrayList<EncogCLPlatform>();
    private final List<EncogCLDevice> devices = new ArrayList<EncogCLDevice>();

    public EncogCL() {
        try {
            int[] numPlatforms = new int[1];
            cl_platform_id[] platformIDs = new cl_platform_id[5];
            CL.clGetPlatformIDs((int)platformIDs.length, (cl_platform_id[])platformIDs, (int[])numPlatforms);
            if (numPlatforms[0] == 0) {
                throw new EncogEngineError("Can't find any OpenCL platforms");
            }
            for (int i = 0; i < numPlatforms[0]; ++i) {
                cl_platform_id platformID = platformIDs[i];
                EncogCLPlatform platform = new EncogCLPlatform(platformID);
                this.platforms.add(platform);
                for (EncogCLDevice device : platform.getDevices()) {
                    this.devices.add(device);
                }
            }
            CL.setExceptionsEnabled((boolean)true);
        }
        catch (UnsatisfiedLinkError ex) {
            throw new MissingOpenCLAdapterError(ex);
        }
    }

    public boolean areCPUsPresent() {
        for (EncogCLDevice device : this.devices) {
            if (!device.isCPU()) continue;
            return true;
        }
        return false;
    }

    public EncogCLDevice chooseDevice() {
        EncogCLDevice result = this.chooseDevice(true);
        if (result == null) {
            result = this.chooseDevice(false);
        }
        return result;
    }

    public EncogCLDevice chooseDevice(boolean useGPU) {
        for (EncogCLDevice device : this.devices) {
            if (useGPU && !device.isCPU()) {
                return device;
            }
            if (useGPU || !device.isCPU()) continue;
            return device;
        }
        return null;
    }

    public void disableAllCPUs() {
        for (EncogCLDevice device : this.devices) {
            if (!device.isCPU()) continue;
            device.setEnabled(false);
        }
    }

    public void enableAllCPUs() {
        for (EncogCLDevice device : this.devices) {
            if (!device.isCPU()) continue;
            device.setEnabled(true);
        }
    }

    public List<EncogCLDevice> getDevices() {
        return this.devices;
    }

    public List<EncogCLDevice> getEnabledDevices() {
        ArrayList<EncogCLDevice> result = new ArrayList<EncogCLDevice>();
        for (EncogCLDevice device : this.devices) {
            if (!device.isEnabled() || !device.getPlatform().isEnabled()) continue;
            result.add(device);
        }
        return result;
    }

    public List<EncogCLPlatform> getPlatforms() {
        return this.platforms;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (EncogCLDevice device : this.devices) {
            result.append(device.toString());
            result.append("\n");
        }
        return result.toString();
    }
}

