/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.opencl;

import org.encog.engine.opencl.EncogCLDevice;
import org.encog.engine.opencl.EncogCLPlatform;
import org.encog.engine.opencl.kernels.EncogKernel;
import org.jocl.CL;
import org.jocl.Pointer;
import org.jocl.cl_command_queue;
import org.jocl.cl_context;
import org.jocl.cl_device_id;
import org.jocl.cl_kernel;
import org.jocl.cl_mem;

public class EncogCLQueue {
    private final cl_command_queue commands;
    private final EncogCLDevice device;

    public EncogCLQueue(EncogCLDevice device) {
        EncogCLPlatform platform = device.getPlatform();
        this.device = device;
        this.commands = CL.clCreateCommandQueue((cl_context)platform.getContext(), (cl_device_id)device.getDevice(), (long)0L, null);
    }

    public void array2Buffer(float[] source, cl_mem targetBuffer) {
        CL.clEnqueueWriteBuffer((cl_command_queue)this.commands, (cl_mem)targetBuffer, (boolean)true, (long)0L, (long)(4 * source.length), (Pointer)Pointer.to((float[])source), (int)0, null, null);
    }

    public void array2Buffer(int[] source, cl_mem targetBuffer) {
        CL.clEnqueueWriteBuffer((cl_command_queue)this.commands, (cl_mem)targetBuffer, (boolean)true, (long)0L, (long)(4 * source.length), (Pointer)Pointer.to((int[])source), (int)0, null, null);
    }

    public void buffer2Array(cl_mem sourceBuffer, float[] target) {
        CL.clEnqueueReadBuffer((cl_command_queue)this.commands, (cl_mem)sourceBuffer, (boolean)true, (long)0L, (long)(target.length * 4), (Pointer)Pointer.to((float[])target), (int)0, null, null);
    }

    public void buffer2Array(cl_mem sourceBuffer, int[] target) {
        CL.clEnqueueReadBuffer((cl_command_queue)this.commands, (cl_mem)sourceBuffer, (boolean)true, (long)0L, (long)(target.length * 4), (Pointer)Pointer.to((int[])target), (int)0, null, null);
    }

    public void execute(EncogKernel kernel) {
        long[] globalWorkSize = new long[]{kernel.getGlobalWork()};
        long[] localWorkSize = new long[]{kernel.getLocalWork()};
        CL.clEnqueueNDRangeKernel((cl_command_queue)this.commands, (cl_kernel)kernel.getKernel(), (int)1, null, (long[])globalWorkSize, (long[])localWorkSize, (int)0, null, null);
    }

    public cl_command_queue getCommands() {
        return this.commands;
    }

    public void waitFinish() {
        CL.clFinish((cl_command_queue)this.commands);
    }

    public EncogCLDevice getDevice() {
        return this.device;
    }
}

