/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.opencl.kernels;

import java.util.HashMap;
import java.util.Map;
import org.encog.engine.EncogEngineError;
import org.encog.engine.opencl.EncogCLDevice;
import org.encog.engine.util.ResourceLoader;
import org.jocl.CL;
import org.jocl.NativePointerObject;
import org.jocl.Pointer;
import org.jocl.Sizeof;
import org.jocl.cl_context;
import org.jocl.cl_device_id;
import org.jocl.cl_kernel;
import org.jocl.cl_mem;
import org.jocl.cl_program;

public class EncogKernel {
    private String cl;
    private final cl_context context;
    private cl_program program;
    private cl_kernel kernel;
    private final EncogCLDevice device;
    private final String sourceName;
    private int localWork;
    private int globalWork;
    private final String kernelName;

    public EncogKernel(EncogCLDevice device, String sourceName, String kernelName) {
        this.sourceName = sourceName;
        this.context = device.getPlatform().getContext();
        this.device = device;
        this.kernelName = kernelName;
        this.cl = ResourceLoader.loadString(sourceName);
    }

    public void compile() {
        this.compile(new HashMap<String, String>());
    }

    public void compile(Map<String, String> options) {
        if (this.program != null) {
            CL.clReleaseProgram((cl_program)this.program);
            CL.clReleaseKernel((cl_kernel)this.kernel);
        }
        cl_program program = CL.clCreateProgramWithSource((cl_context)this.context, (int)1, (String[])new String[]{this.cl}, null, null);
        if (options.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> obj : options.entrySet()) {
                if (builder.length() > 0) {
                    builder.append(" ");
                }
                builder.append("-D ");
                builder.append(obj.getKey());
                builder.append("=");
                builder.append(obj.getValue());
            }
            CL.clBuildProgram((cl_program)program, (int)0, null, (String)builder.toString(), null, null);
        } else {
            CL.clBuildProgram((cl_program)program, (int)0, null, null, null, null);
        }
        this.kernel = CL.clCreateKernel((cl_program)program, (String)this.kernelName, null);
    }

    public cl_mem createArrayReadOnly(float[] array) {
        return CL.clCreateBuffer((cl_context)this.getContext(), (long)36L, (long)(4 * array.length), (Pointer)Pointer.to((float[])array), null);
    }

    public cl_mem createArrayReadOnly(int[] array) {
        return CL.clCreateBuffer((cl_context)this.getContext(), (long)36L, (long)(4 * array.length), (Pointer)Pointer.to((int[])array), null);
    }

    public cl_mem createFloatArrayWriteOnly(int length) {
        return CL.clCreateBuffer((cl_context)this.getContext(), (long)1L, (long)(4 * length), null, null);
    }

    public String getCLSource() {
        return this.cl;
    }

    public cl_context getContext() {
        return this.context;
    }

    public EncogCLDevice getDevice() {
        return this.device;
    }

    public int getGlobalWork() {
        return this.globalWork;
    }

    public cl_kernel getKernel() {
        return this.kernel;
    }

    public int getLocalWork() {
        return this.localWork;
    }

    public int getMaxWorkGroupSize() {
        return (int)this.getWorkGroupLong(4528);
    }

    public cl_program getProgram() {
        return this.program;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public long getWorkGroupLong(int param) {
        long[] result = new long[1];
        long[] len = new long[1];
        CL.clGetKernelWorkGroupInfo((cl_kernel)this.kernel, (cl_device_id)this.device.getDevice(), (int)param, (long)8L, (Pointer)Pointer.to((long[])result), (long[])len);
        return result[0];
    }

    public void prepareKernel() {
        if (this.kernel == null) {
            throw new EncogEngineError("Must compile CL kernel before using it.");
        }
    }

    public void release() {
        if (this.program != null) {
            CL.clReleaseProgram((cl_program)this.program);
            CL.clReleaseKernel((cl_kernel)this.kernel);
            this.program = null;
            this.kernel = null;
        }
    }

    public void releaseBuffer(cl_mem mem) {
        CL.clReleaseMemObject((cl_mem)mem);
    }

    public void setArg(int num, cl_mem mem) {
        CL.clSetKernelArg((cl_kernel)this.getKernel(), (int)num, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject[])new NativePointerObject[]{mem}));
    }

    public void setCLSource(String cl) {
        this.cl = cl;
    }

    public void setGlobalWork(int globalWork) {
        this.globalWork = globalWork;
    }

    public void setLocalWork(int localWork) {
        this.localWork = localWork;
    }
}

