/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.opencl.kernels;

import org.encog.engine.opencl.EncogCLDevice;
import org.encog.engine.opencl.EncogCLQueue;
import org.encog.engine.opencl.kernels.EncogKernel;
import org.jocl.cl_mem;

public class KernelVectorAdd
extends EncogKernel {
    private final float[] arrayA;
    private final float[] arrayB;
    private final float[] targetArray;
    private final cl_mem bufferArrayA;
    private final cl_mem bufferArrayB;
    private final cl_mem bufferTargetArray;

    public KernelVectorAdd(EncogCLDevice device, int length) {
        super(device, "org/encog/engine/resources/KernelVectorAdd.txt", "VectorAdd");
        this.arrayA = new float[length];
        this.arrayB = new float[length];
        this.targetArray = new float[length];
        this.bufferArrayA = this.createArrayReadOnly(this.arrayA);
        this.bufferArrayB = this.createArrayReadOnly(this.arrayB);
        this.bufferTargetArray = this.createFloatArrayWriteOnly(this.targetArray.length);
        this.setGlobalWork(length);
        this.setLocalWork(1);
    }

    public double[] add(EncogCLDevice device, double[] inputA, double[] inputB) {
        for (int i = 0; i < inputA.length; ++i) {
            this.arrayA[i] = (float)inputA[i];
            this.arrayB[i] = (float)inputB[i];
        }
        this.setArg(0, this.bufferArrayA);
        this.setArg(1, this.bufferArrayB);
        this.setArg(2, this.bufferTargetArray);
        EncogCLQueue queue = this.getDevice().getQueue();
        queue.array2Buffer(this.arrayA, this.bufferArrayA);
        queue.array2Buffer(this.arrayB, this.bufferArrayB);
        queue.execute(this);
        queue.buffer2Array(this.bufferTargetArray, this.targetArray);
        double[] result = new double[this.targetArray.length];
        for (int i = 0; i < this.targetArray.length; ++i) {
            result[i] = this.targetArray[i];
        }
        return result;
    }
}

