/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.util;

import org.encog.engine.util.ErrorCalculationMode;

public class ErrorCalculation {
    private static ErrorCalculationMode mode = ErrorCalculationMode.MSE;
    private double globalError;
    private int setSize;

    public static ErrorCalculationMode getMode() {
        return mode;
    }

    public static void setMode(ErrorCalculationMode mode) {
        ErrorCalculation.mode = mode;
    }

    public double calculate() {
        if (this.setSize == 0) {
            return 0.0;
        }
        switch (ErrorCalculation.getMode()) {
            case RMS: {
                return this.calculateRMS();
            }
            case MSE: {
                return this.calculateMSE();
            }
            case ARCTAN: {
                return this.calculateARCTAN();
            }
        }
        return this.calculateMSE();
    }

    public double calculateARCTAN() {
        return this.calculateMSE();
    }

    public double calculateMSE() {
        if (this.setSize == 0) {
            return 0.0;
        }
        double err = this.globalError / (double)this.setSize;
        return err;
    }

    public double calculateRMS() {
        if (this.setSize == 0) {
            return 0.0;
        }
        double err = Math.sqrt(this.globalError / (double)this.setSize);
        return err;
    }

    public void reset() {
        this.globalError = 0.0;
        this.setSize = 0;
    }

    public void updateError(double actual, double ideal) {
        double delta = ideal - actual;
        if (mode == ErrorCalculationMode.ARCTAN) {
            delta = Math.atan(delta);
        }
        this.globalError += delta * delta;
        ++this.setSize;
    }

    public void updateError(double[] actual, double[] ideal) {
        for (int i = 0; i < actual.length; ++i) {
            double delta = ideal[i] - actual[i];
            if (mode == ErrorCalculationMode.ARCTAN) {
                delta = Math.atan(delta);
            }
            this.globalError += delta * delta;
        }
        this.setSize += ideal.length;
    }
}

