/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil;

public final class EncogMath {
    private EncogMath() {
    }

    public static double deg2rad(double deg) {
        return deg * (Math.PI / 180);
    }

    public static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    public static double rad2deg(double rad) {
        return rad * 57.29577951308232;
    }

    public static boolean doubleEquals(double d1, double d2) {
        return Math.abs(d1 - d2) < 1.0E-7;
    }
}

