/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil;

import java.util.List;
import org.encog.engine.util.Format;

public class NumericRange {
    private final double high;
    private final double low;
    private final double mean;
    private final double rms;
    private final double standardDeviation;
    private final int samples;

    public NumericRange(List<Double> values) {
        double assignedHigh = 0.0;
        double assignedLow = 0.0;
        double total = 0.0;
        double rmsTotal = 0.0;
        for (double d : values) {
            assignedHigh = Math.max(assignedHigh, d);
            assignedLow = Math.min(assignedLow, d);
            total += d;
            rmsTotal += d * d;
        }
        this.samples = values.size();
        this.high = assignedHigh;
        this.low = assignedLow;
        this.mean = total / (double)this.samples;
        this.rms = Math.sqrt(rmsTotal / (double)this.samples);
        double devTotal = 0.0;
        for (double d : values) {
            devTotal += Math.pow(d - this.mean, 2.0);
        }
        this.standardDeviation = Math.sqrt(devTotal / (double)this.samples);
    }

    public double getHigh() {
        return this.high;
    }

    public double getLow() {
        return this.low;
    }

    public double getMean() {
        return this.mean;
    }

    public double getRms() {
        return this.rms;
    }

    public int getSamples() {
        return this.samples;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Range: ");
        result.append(Format.formatDouble(this.low, 5));
        result.append(" to ");
        result.append(Format.formatDouble(this.high, 5));
        result.append(",samples: ");
        result.append(Format.formatInteger(this.samples));
        result.append(",mean: ");
        result.append(Format.formatDouble(this.mean, 5));
        result.append(",rms: ");
        result.append(Format.formatDouble(this.rms, 5));
        result.append(",s.deviation: ");
        result.append(Format.formatDouble(this.standardDeviation, 5));
        return result.toString();
    }
}

