/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize;

import org.encog.EncogError;
import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.randomize.BasicRandomizer;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.synapse.Synapse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FanInRandomizer
extends BasicRandomizer {
    static final String ERROR = "To use FanInRandomizer you must present a Matrix or 2D array type value.";
    private static final double DEFAULT_BOUNDARY = 2.4;
    private final double lowerBound;
    private final double upperBound;
    private final boolean sqrt;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public FanInRandomizer() {
        this(-2.4, 2.4, false);
    }

    public FanInRandomizer(double boundary, boolean sqrt) {
        this(-boundary, boundary, sqrt);
    }

    public FanInRandomizer(double aLowerBound, double anUpperBound, boolean sqrt) {
        this.lowerBound = aLowerBound;
        this.upperBound = anUpperBound;
        this.sqrt = sqrt;
    }

    private double calculateValue(int rows) {
        double rowValue = this.sqrt ? Math.sqrt(rows) : (double)rows;
        return this.lowerBound / rowValue + this.nextDouble() * ((this.upperBound - this.lowerBound) / rowValue);
    }

    private void causeError() {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(ERROR);
        }
        throw new EncogError(ERROR);
    }

    @Override
    public void randomize(BasicNetwork network, Synapse synapse) {
        if (synapse.getMatrix() != null) {
            boolean limited = network.getStructure().isConnectionLimited();
            double[][] d = synapse.getMatrix().getData();
            for (int fromNeuron = 0; fromNeuron < synapse.getMatrix().getRows(); ++fromNeuron) {
                for (int toNeuron = 0; toNeuron < synapse.getMatrix().getCols(); ++toNeuron) {
                    if (limited && !network.isConnected(synapse, fromNeuron, toNeuron)) continue;
                    d[fromNeuron][toNeuron] = this.calculateValue(synapse.getMatrix().getRows());
                }
            }
        }
    }

    @Override
    public double randomize(double d) {
        this.causeError();
        return 0.0;
    }

    @Override
    public void randomize(double[] d) {
        for (int i = 0; i < d.length; ++i) {
            d[i] = this.calculateValue(1);
        }
    }

    @Override
    public void randomize(Double[] d) {
        for (int i = 0; i < d.length; ++i) {
            d[i] = this.calculateValue(1);
        }
    }

    @Override
    public void randomize(double[][] d) {
        for (int row = 0; row < d.length; ++row) {
            for (int col = 0; col < d[0].length; ++col) {
                d[row][col] = this.calculateValue(d.length);
            }
        }
    }

    @Override
    public void randomize(Double[][] d) {
        for (int row = 0; row < d.length; ++row) {
            for (int col = 0; col < d[0].length; ++col) {
                d[row][col] = this.calculateValue(d.length);
            }
        }
    }

    @Override
    public void randomize(Matrix m) {
        for (int row = 0; row < m.getRows(); ++row) {
            for (int col = 0; col < m.getCols(); ++col) {
                m.set(row, col, this.calculateValue(m.getRows()));
            }
        }
    }
}

