/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize;

import org.encog.EncogError;
import org.encog.mathutil.randomize.Randomizer;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.structure.FlatUpdateNeeded;
import org.encog.neural.networks.synapse.Synapse;

public class NguyenWidrowRandomizer
extends RangeRandomizer
implements Randomizer {
    public NguyenWidrowRandomizer(double min, double max) {
        super(min, max);
    }

    @Override
    public final void randomize(BasicNetwork network) {
        super.randomize(network);
        int neuronCount = 0;
        for (Layer layer : network.getStructure().getLayers()) {
            neuronCount += layer.getNeuronCount();
        }
        Layer inputLayer = network.getLayer("INPUT");
        Layer outputLayer = network.getLayer("OUTPUT");
        if (inputLayer == null) {
            throw new EncogError("Must have an input layer for Nguyen-Widrow.");
        }
        if (outputLayer == null) {
            throw new EncogError("Must have an output layer for Nguyen-Widrow.");
        }
        int hiddenNeurons = neuronCount - inputLayer.getNeuronCount() - outputLayer.getNeuronCount();
        if (hiddenNeurons < 1) {
            return;
        }
        double beta = 0.7 * Math.pow(hiddenNeurons, 1.0 / (double)inputLayer.getNeuronCount());
        for (Synapse synapse : network.getStructure().getSynapses()) {
            this.randomize(beta, synapse);
        }
        network.getStructure().setFlatUpdate(FlatUpdateNeeded.Flatten);
        network.getStructure().flattenWeights();
    }

    private void randomize(double beta, Synapse synapse) {
        if (synapse.getMatrix() == null) {
            return;
        }
        for (int j = 0; j < synapse.getToNeuronCount(); ++j) {
            double value;
            int k;
            double norm = 0.0;
            for (k = 0; k < synapse.getFromNeuronCount(); ++k) {
                value = synapse.getMatrix().get(k, j);
                norm += value * value;
            }
            if (synapse.getToLayer().hasBias()) {
                double value2 = synapse.getToLayer().getBiasWeight(j);
                norm += value2 * value2;
                norm = Math.sqrt(norm);
            }
            for (k = 0; k < synapse.getFromNeuronCount(); ++k) {
                value = synapse.getMatrix().get(k, j);
                synapse.getMatrix().set(k, j, beta * value / norm);
            }
            if (!synapse.getToLayer().hasBias()) continue;
            double value3 = synapse.getToLayer().getBiasWeight(j);
            synapse.getToLayer().setBiasWeight(j, beta * value3 / norm);
        }
    }
}

