/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.encog.EncogError;
import org.encog.persist.BasicPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PropertyDataPersistor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyData
extends BasicPersistedObject {
    private static final long serialVersionUID = -7940416732740995199L;
    private final Map<String, String> data = new HashMap<String, String>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Object clone() {
        PropertyData result = new PropertyData();
        result.setName(this.getName());
        result.setDescription(this.getDescription());
        result.setCollection(this.getCollection());
        for (String key : this.data.keySet()) {
            result.set(key, this.get(key));
        }
        return result;
    }

    @Override
    public Persistor createPersistor() {
        return new PropertyDataPersistor();
    }

    public String get(String name) {
        return this.data.get(name);
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public Date getDate(String field) {
        try {
            String str = this.get(field);
            SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy");
            Date date = formatter.parse(str);
            return date;
        }
        catch (ParseException e) {
            throw new EncogError(e);
        }
    }

    public double getDouble(String field) {
        String str = this.get(field);
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            throw new EncogError(e);
        }
    }

    public int getInteger(String field) {
        String str = this.get(field);
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new EncogError(e);
        }
    }

    public boolean isDefined(String key) {
        return this.data.containsKey(key);
    }

    public void remove(String key) {
        this.data.remove(key);
    }

    public void set(String name, String value) {
        this.data.put(name, value);
    }

    public int size() {
        return this.data.size();
    }
}

