/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.basic;

import java.io.Serializable;
import org.encog.neural.data.NeuralData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicNeuralData
implements NeuralData,
Serializable,
Cloneable {
    private static final long serialVersionUID = -3644304891793584603L;
    private double[] data;
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public BasicNeuralData(double[] d) {
        this(d.length);
        System.arraycopy(d, 0, this.data, 0, d.length);
    }

    public BasicNeuralData(int size) {
        this.data = new double[size];
    }

    public BasicNeuralData(NeuralData d) {
        this(d.size());
        System.arraycopy(d.getData(), 0, this.data, 0, d.size());
    }

    @Override
    public void add(int index, double value) {
        int n = index;
        this.data[n] = this.data[n] + value;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0.0;
        }
    }

    @Override
    public NeuralData clone() {
        return new BasicNeuralData(this);
    }

    @Override
    public double[] getData() {
        return this.data;
    }

    @Override
    public double getData(int index) {
        return this.data[index];
    }

    @Override
    public void setData(double[] data) {
        this.data = data;
    }

    @Override
    public void setData(int index, double d) {
        this.data[index] = d;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[BasicNeuralData:");
        for (int i = 0; i < this.data.length; ++i) {
            if (i != 0) {
                builder.append(',');
            }
            builder.append(this.data[i]);
        }
        builder.append("]");
        return builder.toString();
    }
}

