/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.basic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.encog.engine.data.EngineData;
import org.encog.neural.data.Indexable;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.persist.EncogCollection;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.BasicNeuralDataSetPersistor;
import org.encog.util.obj.ObjectCloner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicNeuralDataSet
implements EncogPersistedObject,
Serializable,
Indexable {
    private static final long serialVersionUID = -2279722928570071183L;
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private EncogCollection encogCollection;
    private List<NeuralDataPair> data = new ArrayList<NeuralDataPair>();
    private String description;
    private String name;

    public BasicNeuralDataSet() {
    }

    public BasicNeuralDataSet(double[][] input, double[][] ideal) {
        if (ideal != null) {
            for (int i = 0; i < input.length; ++i) {
                BasicNeuralData inputData = new BasicNeuralData(input[i]);
                BasicNeuralData idealData = new BasicNeuralData(ideal[i]);
                this.add(inputData, idealData);
            }
        } else {
            for (double[] element : input) {
                BasicNeuralData inputData = new BasicNeuralData(element);
                this.add(inputData);
            }
        }
    }

    public BasicNeuralDataSet(List<NeuralDataPair> data) {
        this.data = data;
    }

    @Override
    public void add(NeuralData data) {
        this.data.add(new BasicNeuralDataPair(data));
    }

    @Override
    public void add(NeuralData inputData, NeuralData idealData) {
        BasicNeuralDataPair pair = new BasicNeuralDataPair(inputData, idealData);
        this.data.add(pair);
    }

    @Override
    public void add(NeuralDataPair inputData) {
        this.data.add(inputData);
    }

    public Object clone() {
        return ObjectCloner.deepCopy(this);
    }

    @Override
    public void close() {
    }

    @Override
    public Persistor createPersistor() {
        return new BasicNeuralDataSetPersistor();
    }

    public List<NeuralDataPair> getData() {
        return this.data;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getIdealSize() {
        if (this.data.isEmpty()) {
            return 0;
        }
        NeuralDataPair first = this.data.get(0);
        if (first.getIdeal() == null) {
            return 0;
        }
        return first.getIdeal().size();
    }

    @Override
    public int getInputSize() {
        if (this.data.isEmpty()) {
            return 0;
        }
        NeuralDataPair first = this.data.get(0);
        return first.getInput().size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void getRecord(long index, EngineData pair) {
        NeuralDataPair source = this.data.get((int)index);
        pair.setInputArray(source.getInputArray());
        if (pair.getIdealArray() != null) {
            pair.setIdealArray(source.getIdealArray());
        }
    }

    @Override
    public long getRecordCount() {
        return this.data.size();
    }

    @Override
    public boolean isSupervised() {
        if (this.data.size() == 0) {
            return false;
        }
        return this.data.get(0).isSupervised();
    }

    @Override
    public Iterator<NeuralDataPair> iterator() {
        BasicNeuralIterator result = new BasicNeuralIterator();
        return result;
    }

    @Override
    public Indexable openAdditional() {
        return new BasicNeuralDataSet(this.data);
    }

    public void setData(List<NeuralDataPair> data) {
        this.data = data;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public EncogCollection getCollection() {
        return this.encogCollection;
    }

    @Override
    public void setCollection(EncogCollection collection) {
        this.encogCollection = collection;
    }

    public class BasicNeuralIterator
    implements Iterator<NeuralDataPair> {
        private int currentIndex = 0;

        @Override
        public boolean hasNext() {
            return this.currentIndex < BasicNeuralDataSet.this.data.size();
        }

        @Override
        public NeuralDataPair next() {
            if (!this.hasNext()) {
                return null;
            }
            return (NeuralDataPair)BasicNeuralDataSet.this.data.get(this.currentIndex++);
        }

        @Override
        public void remove() {
            if (BasicNeuralDataSet.this.logger.isErrorEnabled()) {
                BasicNeuralDataSet.this.logger.error("Called remove, unsupported operation.");
            }
            throw new UnsupportedOperationException();
        }
    }
}

