/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.bipolar;

import java.io.Serializable;
import org.encog.mathutil.matrices.BiPolarUtil;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiPolarNeuralData
implements NeuralData,
Serializable {
    private static final long serialVersionUID = -6082894455587612231L;
    private boolean[] data;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public BiPolarNeuralData(boolean[] d) {
        this.data = new boolean[d.length];
        System.arraycopy(d, 0, this.data, 0, d.length);
    }

    public BiPolarNeuralData(int size) {
        this.data = new boolean[size];
    }

    @Override
    public void add(int index, double value) {
        throw new NeuralDataError("Add is not supported for bipolar data.");
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = false;
        }
    }

    @Override
    public NeuralData clone() {
        BiPolarNeuralData result = new BiPolarNeuralData(this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.setData(i, this.getData(i));
        }
        return result;
    }

    public boolean getBoolean(int i) {
        return this.data[i];
    }

    @Override
    public double[] getData() {
        return BiPolarUtil.bipolar2double(this.data);
    }

    @Override
    public double getData(int index) {
        return BiPolarUtil.bipolar2double(this.data[index]);
    }

    @Override
    public void setData(double[] data) {
        this.data = BiPolarUtil.double2bipolar(data);
    }

    public void setData(int index, boolean value) {
        this.data[index] = value;
    }

    @Override
    public void setData(int index, double d) {
        this.data[index] = BiPolarUtil.double2bipolar(d);
    }

    @Override
    public int size() {
        return this.data.length;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('[');
        for (int i = 0; i < this.size(); ++i) {
            if (this.getData(i) > 0.0) {
                result.append("T");
            } else {
                result.append("F");
            }
            if (i == this.size() - 1) continue;
            result.append(",");
        }
        result.append(']');
        return result.toString();
    }
}

