/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.buffer;

import java.io.File;
import org.encog.NullStatusReportable;
import org.encog.engine.StatusReportable;
import org.encog.neural.data.buffer.EncogEGBFile;
import org.encog.neural.data.buffer.codec.DataSetCODEC;

public class BinaryDataLoader {
    private DataSetCODEC codec;
    private StatusReportable status = new NullStatusReportable();

    public BinaryDataLoader(DataSetCODEC codec) {
        this.codec = codec;
    }

    public void external2Binary(File binaryFile) {
        this.status.report(0, 0, "Importing to binary file: " + binaryFile.toString());
        EncogEGBFile egb = new EncogEGBFile(binaryFile);
        egb.create(this.codec.getInputSize(), this.codec.getIdealSize());
        double[] input = new double[this.codec.getInputSize()];
        double[] ideal = new double[this.codec.getIdealSize()];
        this.codec.prepareRead();
        int index = 3;
        int currentRecord = 0;
        int lastUpdate = 0;
        while (this.codec.read(input, ideal)) {
            egb.write(input);
            egb.write(ideal);
            index += input.length;
            index += ideal.length;
            ++currentRecord;
            if (++lastUpdate < 10000) continue;
            lastUpdate = 0;
            this.status.report(0, currentRecord, "Importing...");
        }
        egb.close();
        this.codec.close();
        this.status.report(0, 0, "Done importing to binary file: " + binaryFile.toString());
    }

    public void binary2External(File binaryFile) {
        this.status.report(0, 0, "Exporting binary file: " + binaryFile.toString());
        EncogEGBFile egb = new EncogEGBFile(binaryFile);
        egb.open();
        this.codec.prepareWrite(egb.getNumberOfRecords(), egb.getInputCount(), egb.getIdealCount());
        int inputCount = egb.getInputCount();
        int idealCount = egb.getIdealCount();
        double[] input = new double[inputCount];
        double[] ideal = new double[idealCount];
        int currentRecord = 0;
        int lastUpdate = 0;
        for (int i = 0; i < egb.getNumberOfRecords(); ++i) {
            int j;
            for (j = 0; j < inputCount; ++j) {
                input[j] = egb.read();
            }
            for (j = 0; j < idealCount; ++j) {
                ideal[j] = egb.read();
            }
            this.codec.write(input, ideal);
            ++currentRecord;
            if (++lastUpdate < 10000) continue;
            lastUpdate = 0;
            this.status.report(egb.getNumberOfRecords(), currentRecord, "Exporting...");
        }
        egb.close();
        this.codec.close();
        this.status.report(0, 0, "Done exporting binary file: " + binaryFile.toString());
    }

    public StatusReportable getStatus() {
        return this.status;
    }

    public void setStatus(StatusReportable status) {
        this.status = status;
    }

    public DataSetCODEC getCodec() {
        return this.codec;
    }
}

