/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.buffer.codec;

import org.encog.engine.util.EngineArray;
import org.encog.neural.data.buffer.codec.DataSetCODEC;

public class ArrayDataCODEC
implements DataSetCODEC {
    private int index;
    private int inputSize;
    private int idealSize;
    private double[][] input;
    private double[][] ideal;

    public ArrayDataCODEC(double[][] input, double[][] ideal) {
        this.input = input;
        this.ideal = ideal;
        this.inputSize = input[0].length;
        this.idealSize = ideal[0].length;
        this.index = 0;
    }

    public ArrayDataCODEC() {
    }

    @Override
    public int getInputSize() {
        return this.inputSize;
    }

    @Override
    public int getIdealSize() {
        return this.idealSize;
    }

    @Override
    public boolean read(double[] input, double[] ideal) {
        if (this.index >= this.input.length) {
            return false;
        }
        EngineArray.arrayCopy(this.input[this.index], input);
        EngineArray.arrayCopy(this.ideal[this.index], ideal);
        ++this.index;
        return true;
    }

    @Override
    public void write(double[] input, double[] ideal) {
        EngineArray.arrayCopy(input, this.input[this.index]);
        EngineArray.arrayCopy(ideal, this.ideal[this.index]);
        ++this.index;
    }

    @Override
    public void prepareWrite(int recordCount, int inputSize, int idealSize) {
        this.input = new double[recordCount][inputSize];
        this.ideal = new double[recordCount][idealSize];
        this.inputSize = inputSize;
        this.idealSize = idealSize;
        this.index = 0;
    }

    public double[][] getInput() {
        return this.input;
    }

    public double[][] getIdeal() {
        return this.ideal;
    }

    @Override
    public void prepareRead() {
    }

    @Override
    public void close() {
    }
}

