/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.buffer.codec;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.encog.engine.util.EngineArray;
import org.encog.neural.data.buffer.BufferedDataError;
import org.encog.neural.data.buffer.codec.DataSetCODEC;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.encog.util.csv.ReadCSV;

public class CSVDataCODEC
implements DataSetCODEC {
    private File file;
    private CSVFormat format;
    private int inputCount;
    private int idealCount;
    private boolean headers;
    private ReadCSV readCSV;
    private PrintStream output;

    public CSVDataCODEC(File file, CSVFormat format, boolean headers, int inputCount, int idealCount) {
        if (this.inputCount != 0) {
            throw new BufferedDataError("To export CSV, you must use the CSVDataCODEC constructor that does not specify input or ideal sizes.");
        }
        this.file = file;
        this.format = format;
        this.inputCount = inputCount;
        this.idealCount = idealCount;
        this.headers = headers;
    }

    public CSVDataCODEC(File file, CSVFormat format) {
        this.file = file;
        this.format = format;
    }

    @Override
    public boolean read(double[] input, double[] ideal) {
        if (this.readCSV.next()) {
            int i;
            int index = 0;
            for (i = 0; i < input.length; ++i) {
                input[i] = this.readCSV.getDouble(index++);
            }
            for (i = 0; i < ideal.length; ++i) {
                ideal[i] = this.readCSV.getDouble(index++);
            }
            return true;
        }
        return false;
    }

    @Override
    public void write(double[] input, double[] ideal) {
        double[] record = new double[input.length + ideal.length];
        EngineArray.arrayCopy(input, record);
        EngineArray.arrayCopy(ideal, 0, record, input.length, ideal.length);
        StringBuilder result = new StringBuilder();
        NumberList.toList(this.format, result, record);
        this.output.println(result.toString());
    }

    @Override
    public void prepareWrite(int recordCount, int inputSize, int idealSize) {
        try {
            this.inputCount = inputSize;
            this.idealCount = idealSize;
            this.output = new PrintStream(new FileOutputStream(this.file));
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }

    @Override
    public void prepareRead() {
        if (this.inputCount == 0) {
            throw new BufferedDataError("To import CSV, you must use the CSVDataCODEC constructor that specifies input and ideal sizes.");
        }
        this.readCSV = new ReadCSV(this.file.toString(), this.headers, this.format);
    }

    @Override
    public int getInputSize() {
        return this.inputCount;
    }

    @Override
    public int getIdealSize() {
        return this.idealCount;
    }

    @Override
    public void close() {
        if (this.readCSV != null) {
            this.readCSV.close();
            this.readCSV = null;
        }
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
    }
}

