/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.buffer.codec;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.encog.neural.data.buffer.BufferedDataError;
import org.encog.neural.data.buffer.codec.DataSetCODEC;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.location.ResourcePersistence;
import org.encog.util.csv.CSVFormat;

public class ExcelCODEC
implements DataSetCODEC {
    private final File file;
    private ZipFile readZipFile;
    private ZipEntry entry;
    private ReadXML xmlIn;
    private int inputCount;
    private int idealCount;
    private FileOutputStream fos;
    private ZipOutputStream zos;
    private ByteArrayOutputStream buffer;
    private WriteXML xmlOut;
    private int row;

    public ExcelCODEC(File file) {
        this.file = file;
    }

    public ExcelCODEC(File file, int inputCount, int idealCount) {
        this.file = file;
        this.inputCount = inputCount;
        this.idealCount = idealCount;
    }

    @Override
    public void close() {
        if (this.readZipFile != null) {
            try {
                this.readZipFile.close();
                this.readZipFile = null;
            }
            catch (IOException e) {
                throw new BufferedDataError(e);
            }
        }
        if (this.zos != null) {
            try {
                ZipEntry entry = new ZipEntry("xl/worksheets/sheet1.xml");
                this.xmlOut.endTag();
                this.xmlOut.addAttribute("left", "0.7");
                this.xmlOut.addAttribute("right", "0.7");
                this.xmlOut.addAttribute("top", "0.75");
                this.xmlOut.addAttribute("bottom", "0.75");
                this.xmlOut.addAttribute("header", "0.3");
                this.xmlOut.addAttribute("footer", "0.3");
                this.xmlOut.beginTag("pageMargins");
                this.xmlOut.endTag();
                this.xmlOut.endTag();
                this.xmlOut.endDocument();
                byte[] b = this.buffer.toByteArray();
                entry.setSize(b.length);
                entry.setCompressedSize(-1L);
                entry.setMethod(8);
                this.zos.putNextEntry(entry);
                this.zos.write(b);
                this.zos.closeEntry();
                this.zos.close();
                this.zos = null;
            }
            catch (IOException e) {
                throw new BufferedDataError(e);
            }
        }
        if (this.fos != null) {
            try {
                this.fos.close();
                this.fos = null;
            }
            catch (IOException e) {
                throw new BufferedDataError(e);
            }
        }
    }

    @Override
    public int getIdealSize() {
        return this.idealCount;
    }

    @Override
    public int getInputSize() {
        return this.inputCount;
    }

    @Override
    public void prepareRead() {
        try {
            this.readZipFile = new ZipFile(this.file);
            Enumeration<? extends ZipEntry> entries = this.readZipFile.entries();
            this.entry = null;
            while (entries.hasMoreElements()) {
                ZipEntry e = entries.nextElement();
                if (!e.getName().equals("xl/worksheets/sheet1.xml")) continue;
                this.entry = e;
            }
            if (this.entry == null) {
                this.readZipFile.close();
                this.readZipFile = null;
                throw new BufferedDataError("Could not find worksheet.");
            }
            InputStream is = this.readZipFile.getInputStream(this.entry);
            this.xmlIn = new ReadXML(is);
        }
        catch (ZipException e) {
            throw new BufferedDataError("Not a valid Excel file.");
        }
        catch (IOException e) {
            throw new BufferedDataError(e);
        }
    }

    @Override
    public void prepareWrite(int recordCount, int inputSize, int idealSize) {
        this.inputCount = inputSize;
        this.idealCount = idealSize;
        try {
            this.fos = new FileOutputStream(this.file);
            this.zos = new ZipOutputStream(this.fos);
            ResourcePersistence resource = new ResourcePersistence("org/encog/data/blank.xlsx");
            InputStream is = resource.createInputStream();
            ZipInputStream zis = new ZipInputStream(is);
            while (zis.available() > 0) {
                ZipEntry entry = zis.getNextEntry();
                if (entry == null || "xl/worksheets/sheet1.xml".equals(entry.getName())) continue;
                ZipEntry entry2 = new ZipEntry(entry);
                entry2.setCompressedSize(-1L);
                this.zos.putNextEntry(entry2);
                byte[] buffer = new byte[(int)entry.getSize()];
                zis.read(buffer);
                this.zos.write(buffer);
                this.zos.closeEntry();
            }
            zis.close();
            this.buffer = new ByteArrayOutputStream();
            this.xmlOut = new WriteXML(this.buffer);
            this.xmlOut.beginDocument();
            this.xmlOut.addAttribute("xmlns", "http://schemas.openxmlformats.org/spreadsheetml/2006/main");
            this.xmlOut.addAttribute("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
            this.xmlOut.beginTag("worksheet");
            StringBuilder d = new StringBuilder();
            d.append(this.toColumn(this.inputCount + this.idealCount));
            d.append("" + recordCount);
            this.xmlOut.addAttribute("ref", "A1:" + d.toString());
            this.xmlOut.beginTag("dimension");
            this.xmlOut.endTag();
            this.xmlOut.beginTag("sheetViews");
            this.xmlOut.addAttribute("tabSelected", "1");
            this.xmlOut.addAttribute("workbookViewId", "0");
            this.xmlOut.beginTag("sheetView");
            this.xmlOut.endTag();
            this.xmlOut.endTag();
            this.xmlOut.addAttribute("defaultRowHeight", "15");
            this.xmlOut.beginTag("sheetFormatPtr");
            this.xmlOut.endTag();
            this.row = 1;
            this.xmlOut.beginTag("sheetData");
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }

    @Override
    public boolean read(double[] input, double[] ideal) {
        int ch;
        while ((ch = this.xmlIn.read()) != -1) {
            if (ch != 0 || !this.xmlIn.is("row", true)) continue;
            this.readRow(this.xmlIn, input, ideal);
            return true;
        }
        return false;
    }

    private void readRow(ReadXML xmlIn, double[] input, double[] ideal) {
        int ch;
        int index = 0;
        while ((ch = this.xmlIn.read()) != -1) {
            if (ch != 0) continue;
            if (this.xmlIn.is("v", true)) {
                String str = this.xmlIn.readTextToTag();
                double d = CSVFormat.ENGLISH.parse(str);
                if (index < input.length) {
                    input[index] = d;
                } else {
                    ideal[index - input.length] = d;
                }
                ++index;
                continue;
            }
            if (!this.xmlIn.is("row", false)) continue;
            break;
        }
    }

    private String toColumn(int index) {
        StringBuilder result = new StringBuilder();
        int first = index / 26;
        int second = index % 26;
        if (first > 0) {
            result.append((char)(65 + (first - 1)));
            result.append((char)(65 + (second - 1)));
        } else {
            result.append((char)(65 + (second - 1)));
        }
        return result.toString();
    }

    @Override
    public void write(double[] input, double[] ideal) {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("1");
        builder.append(":");
        builder.append(this.inputCount + this.idealCount);
        this.xmlOut.addAttribute("spans", builder.toString());
        this.xmlOut.addAttribute("r", "" + this.row++);
        this.xmlOut.beginTag("row");
        int index = 0;
        for (i = 0; i < this.inputCount; ++i) {
            this.xmlOut.addAttribute("r", this.toColumn(index++));
            this.xmlOut.beginTag("c");
            this.xmlOut.beginTag("v");
            this.xmlOut.addText(CSVFormat.EG_FORMAT.format(input[i], 10));
            this.xmlOut.endTag();
            this.xmlOut.endTag();
        }
        for (i = 0; i < this.idealCount; ++i) {
            this.xmlOut.addAttribute("r", this.toColumn(index++));
            this.xmlOut.beginTag("c");
            this.xmlOut.beginTag("v");
            this.xmlOut.addText(CSVFormat.EG_FORMAT.format(ideal[i], 10));
            this.xmlOut.endTag();
            this.xmlOut.endTag();
        }
        this.xmlOut.endTag();
    }
}

