/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.image;

import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralDataSet;
import org.encog.neural.data.image.ImageNeuralData;
import org.encog.util.downsample.Downsample;

public class ImageNeuralDataSet
extends BasicNeuralDataSet {
    private static final long serialVersionUID = 3368190842312829906L;
    public static final String MUST_USE_IMAGE = "This data set only supports ImageNeuralData or Image objects.";
    private final Downsample downsampler;
    private int height;
    private int width;
    private final boolean findBounds;
    private final double hi;
    private final double lo;

    public ImageNeuralDataSet(Downsample downsampler, boolean findBounds, double hi, double lo) {
        this.downsampler = downsampler;
        this.findBounds = findBounds;
        this.height = -1;
        this.width = -1;
        this.hi = hi;
        this.lo = lo;
    }

    @Override
    public void add(NeuralData data) {
        if (!(data instanceof ImageNeuralData)) {
            throw new NeuralNetworkError(MUST_USE_IMAGE);
        }
        super.add(data);
    }

    @Override
    public void add(NeuralData inputData, NeuralData idealData) {
        if (!(inputData instanceof ImageNeuralData)) {
            throw new NeuralNetworkError(MUST_USE_IMAGE);
        }
        super.add(inputData, idealData);
    }

    @Override
    public void add(NeuralDataPair inputData) {
        if (!(inputData.getInput() instanceof ImageNeuralData)) {
            throw new NeuralNetworkError(MUST_USE_IMAGE);
        }
        super.add(inputData);
    }

    public void downsample(int height, int width) {
        this.height = height;
        this.width = width;
        for (NeuralDataPair pair : this) {
            if (!(pair.getInput() instanceof ImageNeuralData)) {
                throw new NeuralNetworkError("Invalid class type found in ImageNeuralDataSet, only ImageNeuralData items are allowed.");
            }
            ImageNeuralData input = (ImageNeuralData)pair.getInput();
            input.downsample(this.downsampler, this.findBounds, height, width, this.hi, this.lo);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }
}

