/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataError;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.parse.tags.read.ReadXML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLNeuralDataSet
implements NeuralDataSet {
    private static final long serialVersionUID = -5960796361565902008L;
    public static final String ADD_NOT_SUPPORTED = "Adds are not supported with this dataset, it is read only.";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String filename;
    private final String pairXML;
    private final String inputXML;
    private final String idealXML;
    private final String valueXML;
    private final int inputSize;
    private final int idealSize;
    private final List<XMLNeuralIterator> iterators = new ArrayList<XMLNeuralIterator>();

    public XMLNeuralDataSet(String filename, int inputSize, int idealSize, String pairXML, String inputXML, String idealXML, String valueXML) {
        this.filename = filename;
        this.pairXML = pairXML;
        this.inputXML = inputXML;
        this.idealXML = idealXML;
        this.valueXML = valueXML;
        this.idealSize = idealSize;
        this.inputSize = inputSize;
    }

    @Override
    public void add(NeuralData data1) {
        throw new NeuralDataError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void add(NeuralData inputData, NeuralData idealData) {
        throw new NeuralDataError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void add(NeuralDataPair inputData) {
        throw new NeuralDataError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void close() {
        for (int i = 0; i < this.iterators.size(); ++i) {
            XMLNeuralIterator iterator = this.iterators.get(i);
            iterator.remove();
        }
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public int getIdealSize() {
        return this.idealSize;
    }

    public String getIdealXML() {
        return this.idealXML;
    }

    @Override
    public int getInputSize() {
        return this.inputSize;
    }

    public String getInputXML() {
        return this.inputXML;
    }

    public String getPairXML() {
        return this.pairXML;
    }

    public String getValueXML() {
        return this.valueXML;
    }

    @Override
    public Iterator<NeuralDataPair> iterator() {
        XMLNeuralIterator result = new XMLNeuralIterator();
        this.iterators.add(result);
        return result;
    }

    @Override
    public boolean isSupervised() {
        return this.idealSize > 0;
    }

    public class XMLNeuralIterator
    implements Iterator<NeuralDataPair> {
        private InputStream file;
        private ReadXML reader;
        private NeuralDataPair nextPair;

        public XMLNeuralIterator() {
            try {
                this.file = new FileInputStream(XMLNeuralDataSet.this.getFilename());
                this.reader = new ReadXML(this.file);
            }
            catch (IOException e) {
                if (XMLNeuralDataSet.this.logger.isErrorEnabled()) {
                    XMLNeuralDataSet.this.logger.error("Exception", (Throwable)e);
                }
                throw new NeuralNetworkError(e);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextPair != null) {
                return true;
            }
            return this.obtainNext();
        }

        private void invalidError() {
            String str = "Could not parse XML, inconsistant tag structure.";
            if (XMLNeuralDataSet.this.logger.isErrorEnabled()) {
                XMLNeuralDataSet.this.logger.error("Could not parse XML, inconsistant tag structure.");
            }
            throw new NeuralNetworkError("Could not parse XML, inconsistant tag structure.");
        }

        @Override
        public NeuralDataPair next() {
            NeuralDataPair result = this.nextPair;
            if (result == null) {
                if (!this.obtainNext()) {
                    return null;
                }
                result = this.nextPair;
            }
            this.nextPair = null;
            return result;
        }

        private boolean obtainNext() {
            String str;
            int i;
            if (!this.reader.findTag(XMLNeuralDataSet.this.getPairXML(), true)) {
                return false;
            }
            BasicNeuralData input = new BasicNeuralData(XMLNeuralDataSet.this.inputSize);
            BasicNeuralData ideal = new BasicNeuralData(XMLNeuralDataSet.this.idealSize);
            if (!this.reader.findTag(XMLNeuralDataSet.this.getInputXML(), true)) {
                this.invalidError();
            }
            for (i = 0; i < XMLNeuralDataSet.this.inputSize; ++i) {
                if (!this.reader.findTag(XMLNeuralDataSet.this.getValueXML(), true)) {
                    this.invalidError();
                }
                str = this.reader.readTextToTag();
                input.setData(i, Double.parseDouble(str));
            }
            if (XMLNeuralDataSet.this.idealSize > 0) {
                if (!this.reader.findTag(XMLNeuralDataSet.this.getIdealXML(), true)) {
                    this.invalidError();
                }
                for (i = 0; i < XMLNeuralDataSet.this.idealSize; ++i) {
                    if (!this.reader.findTag(XMLNeuralDataSet.this.getValueXML(), true)) {
                        this.invalidError();
                    }
                    str = this.reader.readTextToTag();
                    ideal.setData(i, Double.parseDouble(str));
                }
            }
            this.nextPair = ideal != null ? new BasicNeuralDataPair(input, ideal) : new BasicNeuralDataPair(input);
            return true;
        }

        @Override
        public void remove() {
            try {
                this.file.close();
                XMLNeuralDataSet.this.iterators.remove(this);
            }
            catch (IOException e) {
                if (XMLNeuralDataSet.this.logger.isErrorEnabled()) {
                    XMLNeuralDataSet.this.logger.error("Error", (Throwable)e);
                }
                throw new NeuralNetworkError(e);
            }
        }
    }
}

