/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.encog.engine.util.EngineArray;
import org.encog.engine.util.ErrorCalculation;
import org.encog.mathutil.randomize.NguyenWidrowRandomizer;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.networks.ContextClearable;
import org.encog.neural.networks.Network;
import org.encog.neural.networks.NeuralOutputHolder;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.logic.NeuralLogic;
import org.encog.neural.networks.logic.SimpleRecurrentLogic;
import org.encog.neural.networks.structure.FlatUpdateNeeded;
import org.encog.neural.networks.structure.NetworkCODEC;
import org.encog.neural.networks.structure.NeuralStructure;
import org.encog.neural.networks.synapse.Synapse;
import org.encog.neural.networks.synapse.SynapseType;
import org.encog.persist.BasicPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.BasicNetworkPersistor;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.encog.util.obj.ObjectCloner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicNetwork
extends BasicPersistedObject
implements Serializable,
Network,
ContextClearable {
    public static final String TAG_INPUT = "INPUT";
    public static final String TAG_OUTPUT = "OUTPUT";
    public static final String TAG_LIMIT = "CONNECTION_LIMIT";
    public static final String DEFAULT_CONNECTION_LIMIT = "0.0000000001";
    private static final long serialVersionUID = -136440631687066461L;
    private static final transient Logger LOGGER = LoggerFactory.getLogger(BasicNetwork.class);
    private final NeuralStructure structure;
    private NeuralLogic logic;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<String, Layer> layerTags = new HashMap<String, Layer>();

    public static int determineWinner(NeuralData output) {
        int win = 0;
        double biggest = Double.MIN_VALUE;
        for (int i = 0; i < output.size(); ++i) {
            if (!(output.getData(i) > biggest)) continue;
            biggest = output.getData(i);
            win = i;
        }
        return win;
    }

    public BasicNetwork() {
        this.structure = new NeuralStructure(this);
        this.logic = new SimpleRecurrentLogic();
    }

    public BasicNetwork(NeuralLogic logic) {
        this.structure = new NeuralStructure(this);
        this.logic = logic;
    }

    @Override
    public void addLayer(Layer layer) {
        layer.setNetwork(this);
        this.structure.assignID(layer);
        this.addLayer(layer, SynapseType.Weighted);
    }

    @Override
    public void addLayer(Layer layer, SynapseType type) {
        if (this.layerTags.size() == 0) {
            this.tagLayer(TAG_INPUT, layer);
            this.tagLayer(TAG_OUTPUT, layer);
        } else {
            Layer outputLayer = this.getLayer(TAG_OUTPUT);
            outputLayer.addNext(layer, type);
            this.tagLayer(TAG_OUTPUT, layer);
        }
    }

    @Override
    public double calculateError(NeuralDataSet data) {
        ErrorCalculation errorCalculation = new ErrorCalculation();
        this.clearContext();
        for (NeuralDataPair pair : data) {
            NeuralData actual = this.compute(pair.getInput());
            errorCalculation.updateError(actual.getData(), pair.getIdeal().getData());
        }
        return errorCalculation.calculate();
    }

    @Override
    public int calculateNeuronCount() {
        int result = 0;
        for (Layer layer : this.structure.getLayers()) {
            result += layer.getNeuronCount();
        }
        return result;
    }

    @Override
    public void clearContext() {
        for (Layer layer : this.structure.getLayers()) {
            if (!(layer instanceof ContextClearable)) continue;
            ((ContextClearable)((Object)layer)).clearContext();
        }
        for (Synapse synapse : this.structure.getSynapses()) {
            if (!(synapse instanceof ContextClearable)) continue;
            ((ContextClearable)((Object)synapse)).clearContext();
        }
        this.structure.updateFlatNetwork();
        if (this.structure.getFlat() != null) {
            this.structure.getFlat().clearContext();
        }
    }

    public void clearLayerTags() {
        this.layerTags.clear();
    }

    @Override
    public Object clone() {
        BasicNetwork result = (BasicNetwork)ObjectCloner.deepCopy(this);
        result.getStructure().finalizeStructure();
        return result;
    }

    @Override
    public void compute(double[] input, double[] output) {
        BasicNeuralData input2 = new BasicNeuralData(input);
        NeuralData output2 = this.compute(input2);
        EngineArray.arrayCopy(output2.getData(), output);
    }

    @Override
    public NeuralData compute(NeuralData input) {
        try {
            return this.logic.compute(input, null);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new NeuralNetworkError("Index exception: there was likely a mismatch between layer sizes, or the size of the input presented to the network.", ex);
        }
    }

    @Override
    public NeuralData compute(NeuralData input, NeuralOutputHolder useHolder) {
        return this.logic.compute(input, useHolder);
    }

    @Override
    public Persistor createPersistor() {
        return new BasicNetworkPersistor();
    }

    public String dumpWeights() {
        this.structure.updateFlatNetwork();
        StringBuilder result = new StringBuilder();
        NumberList.toList(CSVFormat.EG_FORMAT, result, this.structure.getFlat().getWeights());
        return result.toString();
    }

    public void enableConnection(Synapse synapse, int fromNeuron, int toNeuron, boolean enable) {
        if (synapse.getMatrix() == null) {
            throw new NeuralNetworkError("Can't enable/disable connection on a synapse that does not have a weight matrix.");
        }
        double value = synapse.getMatrix().get(fromNeuron, toNeuron);
        if (enable) {
            if (!this.structure.isConnectionLimited()) {
                return;
            }
            if (Math.abs(value) < this.structure.getConnectionLimit()) {
                synapse.getMatrix().set(fromNeuron, toNeuron, RangeRandomizer.randomize(-1.0, 1.0));
            }
        } else {
            if (!this.structure.isConnectionLimited()) {
                this.properties.put(TAG_LIMIT, DEFAULT_CONNECTION_LIMIT);
                this.structure.finalizeStructure();
            }
            synapse.getMatrix().set(fromNeuron, toNeuron, 0.0);
        }
        this.structure.setFlatUpdate(FlatUpdateNeeded.Flatten);
    }

    @Override
    public boolean equals(BasicNetwork other) {
        return this.equals(other, 10);
    }

    @Override
    public boolean equals(BasicNetwork other, int precision) {
        return NetworkCODEC.equals(this, other, precision);
    }

    @Override
    public int getInputCount() {
        Layer layer = this.layerTags.get(TAG_INPUT);
        if (layer == null) {
            return 0;
        }
        return layer.getNeuronCount();
    }

    public Layer getLayer(String tag) {
        return this.layerTags.get(tag);
    }

    public Map<String, Layer> getLayerTags() {
        return this.layerTags;
    }

    public NeuralLogic getLogic() {
        return this.logic;
    }

    @Override
    public int getOutputCount() {
        Layer layer = this.layerTags.get(TAG_OUTPUT);
        if (layer == null) {
            return 0;
        }
        return layer.getNeuronCount();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public double getPropertyDouble(String name) {
        return Double.parseDouble(this.properties.get(name));
    }

    public long getPropertyLong(String name) {
        return Long.parseLong(this.properties.get(name));
    }

    public String getPropertyString(String name) {
        return this.properties.get(name);
    }

    @Override
    public NeuralStructure getStructure() {
        return this.structure;
    }

    public Collection<String> getTags(Layer layer) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Layer> entry : this.layerTags.entrySet()) {
            if (entry.getValue() != layer) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    @Override
    public int getWeightMatrixSize() {
        int result = 0;
        for (Synapse synapse : this.structure.getSynapses()) {
            result += synapse.getMatrixSize();
        }
        return result;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isConnected(Synapse synapse, int fromNeuron, int toNeuron) {
        if (!this.structure.isConnectionLimited()) {
            return true;
        }
        double value = synapse.getMatrix().get(fromNeuron, toNeuron);
        return Math.abs(value) > this.structure.getConnectionLimit();
    }

    @Override
    public void reset() {
        Layer inputLayer = this.getLayer(TAG_INPUT);
        Layer outputLayer = this.getLayer(TAG_OUTPUT);
        if (this.structure.getLayers().size() < 3 || inputLayer == null || outputLayer == null) {
            new RangeRandomizer(-1.0, 1.0).randomize(this);
        } else {
            new NguyenWidrowRandomizer(-1.0, 1.0).randomize(this);
        }
        this.structure.setFlatUpdate(FlatUpdateNeeded.Flatten);
        this.structure.flattenWeights();
    }

    public void setBiasActivation(double activation) {
        for (Layer layer : this.structure.getLayers()) {
            if (!layer.hasBias()) continue;
            layer.setBiasActivation(activation);
        }
    }

    public void setLogic(NeuralLogic logic) {
        this.logic = logic;
    }

    public void setProperty(String name, double d) {
        this.properties.put(name, "" + d);
    }

    public void setProperty(String name, long l) {
        this.properties.put(name, "" + l);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void tagLayer(String tag, Layer layer) {
        layer.setNetwork(this);
        this.layerTags.put(tag, layer);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[BasicNetwork: Layers=");
        int layers = this.structure.getLayers().size();
        builder.append(layers);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int winner(NeuralData input) {
        NeuralData output = this.compute(input);
        return BasicNetwork.determineWinner(output);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.structure.updateFlatNetwork();
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.structure.finalizeStructure();
    }
}

