/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.layers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationTANH;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.synapse.DirectSynapse;
import org.encog.neural.networks.synapse.OneToOneSynapse;
import org.encog.neural.networks.synapse.Synapse;
import org.encog.neural.networks.synapse.SynapseType;
import org.encog.neural.networks.synapse.WeightedSynapse;
import org.encog.neural.networks.synapse.WeightlessSynapse;
import org.encog.neural.networks.synapse.neat.NEATSynapse;
import org.encog.persist.EncogCollection;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.BasicLayerPersistor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicLayer
implements Layer,
Serializable {
    private static final long serialVersionUID = -5682296868750703898L;
    private static final transient Logger LOGGER = LoggerFactory.getLogger(BasicLayer.class);
    private final List<Synapse> next = new ArrayList<Synapse>();
    private int x;
    private int y;
    private int id;
    private ActivationFunction activationFunction;
    private String description;
    private String name;
    private int neuronCount;
    private double[] biasWeights;
    private BasicNetwork network;
    private double biasActivation;

    public BasicLayer() {
        this(1);
    }

    public BasicLayer(ActivationFunction activationFunction, boolean hasBias, int neuronCount) {
        this.neuronCount = neuronCount;
        this.id = -1;
        this.biasActivation = 1.0;
        this.setActivationFunction(activationFunction);
        if (hasBias) {
            this.biasWeights = new double[neuronCount];
        }
    }

    public BasicLayer(int neuronCount) {
        this(new ActivationTANH(), true, neuronCount);
    }

    @Override
    public void addNext(Layer next) {
        this.addNext(next, SynapseType.Weighted);
    }

    @Override
    public void addNext(Layer next, SynapseType type) {
        Synapse synapse = null;
        if (this.network == null) {
            throw new NeuralNetworkError("Can't add to this layer, it is not yet part of a network itself.");
        }
        next.setNetwork(this.network);
        this.network.getStructure().assignID(next);
        switch (type) {
            case OneToOne: {
                synapse = new OneToOneSynapse(this, next);
                break;
            }
            case Weighted: {
                synapse = new WeightedSynapse(this, next);
                break;
            }
            case Weightless: {
                synapse = new WeightlessSynapse(this, next);
                break;
            }
            case Direct: {
                synapse = new DirectSynapse(this, next);
                break;
            }
            case NEAT: {
                synapse = new NEATSynapse(this, next);
                break;
            }
            default: {
                throw new NeuralNetworkError("Unknown synapse type");
            }
        }
        if (synapse == null) {
            String str = "Unknown synapse type.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Unknown synapse type.");
            }
            throw new NeuralNetworkError("Unknown synapse type.");
        }
        this.next.add(synapse);
    }

    @Override
    public void addSynapse(Synapse synapse) {
        this.next.add(synapse);
    }

    @Override
    public int compareTo(Layer other) {
        if (other.getID() == this.getID()) {
            return 0;
        }
        if (other.getID() > this.getID()) {
            return 1;
        }
        return -1;
    }

    @Override
    public NeuralData compute(NeuralData pattern) {
        NeuralData result = pattern.clone();
        if (this.hasBias()) {
            for (int i = 0; i < this.biasWeights.length; ++i) {
                result.setData(i, result.getData(i) + this.biasWeights[i] * this.biasActivation);
            }
        }
        this.getActivationFunction().activationFunction(result.getData(), 0, result.getData().length);
        return result;
    }

    @Override
    public Persistor createPersistor() {
        return new BasicLayerPersistor();
    }

    @Override
    public ActivationFunction getActivationFunction() {
        return this.activationFunction;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BasicNetwork getNetwork() {
        return this.network;
    }

    @Override
    public int getNeuronCount() {
        return this.neuronCount;
    }

    @Override
    public List<Synapse> getNext() {
        return this.next;
    }

    @Override
    public Collection<Layer> getNextLayers() {
        HashSet<Layer> result = new HashSet<Layer>();
        for (Synapse synapse : this.next) {
            result.add(synapse.getToLayer());
        }
        return result;
    }

    @Override
    public double[] getBiasWeights() {
        return this.biasWeights;
    }

    @Override
    public double getBiasWeight(int index) {
        if (!this.hasBias()) {
            String str = "Attempting to access bias on a layer that has no bias.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Attempting to access bias on a layer that has no bias.");
            }
            throw new NeuralNetworkError("Attempting to access bias on a layer that has no bias.");
        }
        return this.biasWeights[index];
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public boolean hasBias() {
        return this.biasWeights != null;
    }

    @Override
    public boolean isConnectedTo(Layer layer) {
        for (Synapse synapse : this.next) {
            if (synapse.getToLayer() != layer) continue;
            return true;
        }
        return false;
    }

    public boolean isSelfConnected() {
        for (Synapse synapse : this.next) {
            if (!synapse.isSelfConnected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void process(NeuralData pattern) {
    }

    @Override
    public NeuralData recur() {
        return null;
    }

    @Override
    public void setActivationFunction(ActivationFunction f) {
        this.activationFunction = f;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setID(int id) {
        this.id = id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setNetwork(BasicNetwork network) {
        this.network = network;
    }

    @Override
    public void setNeuronCount(int neuronCount) {
        this.neuronCount = neuronCount;
    }

    @Override
    public void setBiasWeights(double[] d) {
        this.biasWeights = d;
    }

    @Override
    public void setBiasWeight(int index, double d) {
        if (!this.hasBias()) {
            String str = "Attempting to set a bias weight on a layer that does not use bias.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Attempting to set a bias weight on a layer that does not use bias.");
            }
            throw new NeuralNetworkError("Attempting to set a bias weight on a layer that does not use bias.");
        }
        this.biasWeights[index] = d;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        result.append(this.getClass().getSimpleName());
        result.append("(");
        result.append(this.getID());
        result.append(")");
        result.append(": neuronCount=");
        result.append(this.neuronCount);
        result.append(']');
        return result.toString();
    }

    @Override
    public double getBiasActivation() {
        return this.biasActivation;
    }

    @Override
    public void setBiasActivation(double activation) {
        this.biasActivation = activation;
    }

    @Override
    public EncogCollection getCollection() {
        return null;
    }

    @Override
    public void setCollection(EncogCollection collection) {
    }
}

