/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.layers;

import org.encog.engine.network.activation.ActivationLinear;
import org.encog.engine.network.rbf.RadialBasisFunction;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.mathutil.rbf.GaussianFunction;
import org.encog.mathutil.rbf.InverseMultiquadricFunction;
import org.encog.mathutil.rbf.MultiquadricFunction;
import org.encog.mathutil.rbf.RBFEnum;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.RadialBasisFunctionLayerPersistor;

public class RadialBasisFunctionLayer
extends BasicLayer {
    private static final long serialVersionUID = 2779781041654829282L;
    private RadialBasisFunction[] radialBasisFunction;

    public RadialBasisFunctionLayer() {
        this(1);
    }

    public RadialBasisFunctionLayer(int neuronCount) {
        super(new ActivationLinear(), false, neuronCount);
        this.radialBasisFunction = new RadialBasisFunction[neuronCount];
    }

    @Override
    public NeuralData compute(NeuralData pattern) {
        BasicNeuralData result = new BasicNeuralData(this.getNeuronCount());
        for (int i = 0; i < this.getNeuronCount(); ++i) {
            if (this.radialBasisFunction[i] == null) {
                String str = "Error, must define radial functions for each neuron";
                throw new NeuralNetworkError("Error, must define radial functions for each neuron");
            }
            RadialBasisFunction f = this.radialBasisFunction[i];
            if (pattern.getData().length != f.getDimensions()) {
                throw new NeuralNetworkError("Inputs must equal the number of dimensions.");
            }
            result.setData(i, f.calculate(pattern.getData()));
        }
        return result;
    }

    @Override
    public Persistor createPersistor() {
        return new RadialBasisFunctionLayerPersistor();
    }

    public RadialBasisFunction[] getRadialBasisFunction() {
        return this.radialBasisFunction;
    }

    public void randomizeRBFCentersAndWidths(int dimensions, double min, double max, RBFEnum t) {
        int i;
        double[] centers = new double[dimensions];
        for (i = 0; i < dimensions; ++i) {
            centers[i] = RangeRandomizer.randomize(min, max);
        }
        for (i = 0; i < this.getNeuronCount(); ++i) {
            this.setRBFFunction(i, t, centers, RangeRandomizer.randomize(min, max));
        }
    }

    public void setRadialBasisFunction(RadialBasisFunction[] v) {
        this.radialBasisFunction = v;
    }

    public void setRBFCentersAndWidths(double[][] centers, double[] widths, RBFEnum t) {
        for (int i = 0; i < this.getNeuronCount(); ++i) {
            this.setRBFFunction(i, t, centers[i], widths[i]);
        }
    }

    public void setRBFCentersAndWidthsEqualSpacing(double minPosition, double maxPosition, RBFEnum t, int dimensions, double volumeNeuronRBFWidth, boolean useWideEdgeRBFs) {
        int totalNumHiddenNeurons = this.getNeuronCount();
        double disMinMaxPosition = Math.abs(maxPosition - minPosition);
        int expectedSideLength = (int)Math.pow(totalNumHiddenNeurons, 1.0 / (double)dimensions);
        if ((double)expectedSideLength != Math.pow(totalNumHiddenNeurons, 1.0 / (double)dimensions)) {
            throw new NeuralNetworkError("Total number of RBF neurons must be some integer to the power of 'dimensions'.");
        }
        double edgeNeuronRBFWidth = 2.5 * volumeNeuronRBFWidth;
        double[][] centers = new double[totalNumHiddenNeurons][];
        double[] widths = new double[totalNumHiddenNeurons];
        for (int i = 0; i < totalNumHiddenNeurons; ++i) {
            centers[i] = new double[dimensions];
            int sideLength = expectedSideLength;
            int temp = i;
            for (int j = dimensions; j > 0; --j) {
                centers[i][j - 1] = (double)((int)((double)temp / Math.pow(sideLength, j - 1))) * (disMinMaxPosition / (double)(sideLength - 1)) + minPosition;
                temp %= (int)Math.pow(sideLength, j - 1);
            }
            boolean contains = false;
            for (int z = 0; z < centers[0].length; ++z) {
                if (centers[i][z] != 1.0 && centers[i][z] != 0.0) continue;
                contains = true;
            }
            widths[i] = contains && useWideEdgeRBFs ? edgeNeuronRBFWidth : volumeNeuronRBFWidth;
        }
        this.setRBFCentersAndWidths(centers, widths, t);
    }

    public void setRBFFunction(int index, RBFEnum t, double[] centers, double width) {
        if (t == RBFEnum.Gaussian) {
            this.radialBasisFunction[index] = new GaussianFunction(0.5, centers, width);
        } else if (t == RBFEnum.Multiquadric) {
            this.radialBasisFunction[index] = new MultiquadricFunction(0.5, centers, width);
        } else if (t == RBFEnum.InverseMultiquadric) {
            this.radialBasisFunction[index] = new InverseMultiquadricFunction(0.5, centers, width);
        }
    }
}

