/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.logic;

import org.encog.engine.util.BoundMath;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.NeuralOutputHolder;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.logic.ThermalLogic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoltzmannLogic
extends ThermalLogic {
    private static final long serialVersionUID = 8067779325187120187L;
    public static final String PROPERTY_RUN_CYCLES = "RCYCLE";
    public static final String PROPERTY_ANNEAL_CYCLES = "ACYCLE";
    public static final String PROPERTY_TEMPERATURE = "TEMPERATURE";
    private static final transient Logger LOGGER = LoggerFactory.getLogger(BoltzmannLogic.class);
    private double temperature;
    private int[] on;
    private int[] off;
    private int annealCycles;
    private int runCycles;

    @Override
    public NeuralData compute(NeuralData input, NeuralOutputHolder useHolder) {
        String str = "Compute on BasicNetwork cannot be used, rather call the run method on the logic class.";
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error("Compute on BasicNetwork cannot be used, rather call the run method on the logic class.");
        }
        throw new NeuralNetworkError("Compute on BasicNetwork cannot be used, rather call the run method on the logic class.");
    }

    public void decreaseTemperature(double d) {
        this.temperature *= d;
    }

    public void establishEquilibrium() {
        int n;
        int i;
        int count = this.getThermalSynapse().getFromNeuronCount();
        for (i = 0; i < count; ++i) {
            this.on[i] = 0;
            this.off[i] = 0;
        }
        for (n = 0; n < this.runCycles * count; ++n) {
            this.run((int)RangeRandomizer.randomize(0.0, count - 1));
        }
        for (n = 0; n < this.annealCycles * count; ++n) {
            i = (int)RangeRandomizer.randomize(0.0, count - 1);
            this.run(i);
            if (this.getCurrentState().getBoolean(i)) {
                int n2 = i;
                this.on[n2] = this.on[n2] + 1;
                continue;
            }
            int n3 = i;
            this.off[n3] = this.off[n3] + 1;
        }
        for (i = 0; i < count; ++i) {
            this.getCurrentState().setData(i, this.on[i] > this.off[i]);
        }
    }

    public double getTemperature() {
        return this.temperature;
    }

    @Override
    public void init(BasicNetwork network) {
        super.init(network);
        Layer layer = this.getNetwork().getLayer("INPUT");
        this.on = new int[layer.getNeuronCount()];
        this.off = new int[layer.getNeuronCount()];
        this.temperature = this.getNetwork().getPropertyDouble(PROPERTY_TEMPERATURE);
        this.runCycles = (int)this.getNetwork().getPropertyLong(PROPERTY_RUN_CYCLES);
        this.annealCycles = (int)this.getNetwork().getPropertyLong(PROPERTY_ANNEAL_CYCLES);
    }

    public void run() {
        int count = this.getThermalSynapse().getFromNeuronCount();
        for (int i = 0; i < count; ++i) {
            this.run(i);
        }
    }

    void run(int i) {
        int count = this.getThermalSynapse().getFromNeuronCount();
        double sum = 0.0;
        for (int j = 0; j < count; ++j) {
            sum += this.getThermalSynapse().getMatrix().get(i, j) * (double)(this.getCurrentState().getBoolean(j) ? 1 : 0);
        }
        double probability = 1.0 / (1.0 + BoundMath.exp(-(sum -= this.getThermalLayer().getBiasWeight(i)) / this.temperature));
        if (RangeRandomizer.randomize(0.0, 1.0) <= probability) {
            this.getCurrentState().setData(i, true);
        } else {
            this.getCurrentState().setData(i, false);
        }
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }
}

