/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.logic;

import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.matrices.MatrixMath;
import org.encog.neural.data.NeuralData;
import org.encog.neural.networks.logic.ThermalLogic;

public class HopfieldLogic
extends ThermalLogic {
    private static final long serialVersionUID = 6522005686471473074L;

    public void addPattern(NeuralData pattern) {
        Matrix m2 = Matrix.createRowMatrix(pattern.getData());
        Matrix m1 = MatrixMath.transpose(m2);
        Matrix m3 = MatrixMath.multiply(m1, m2);
        Matrix identity = MatrixMath.identity(m3.getRows());
        Matrix m4 = MatrixMath.subtract(m3, identity);
        this.convertHopfieldMatrix(m4);
    }

    private void convertHopfieldMatrix(Matrix delta) {
        for (int row = 0; row < delta.getRows(); ++row) {
            for (int col = 0; col < delta.getRows(); ++col) {
                this.getThermalSynapse().getMatrix().add(row, col, delta.get(row, col));
            }
        }
    }

    public void run() {
        NeuralData temp = this.compute(this.getCurrentState(), null);
        for (int i = 0; i < temp.size(); ++i) {
            this.getCurrentState().setData(i, temp.getData(i) > 0.0);
        }
    }

    public int runUntilStable(int max) {
        boolean done = false;
        String lastStateStr = this.getCurrentState().toString();
        String currentStateStr = this.getCurrentState().toString();
        int cycle = 0;
        do {
            this.run();
            ++cycle;
            lastStateStr = this.getCurrentState().toString();
            if (!currentStateStr.equals(lastStateStr)) {
                if (cycle > max) {
                    done = true;
                }
            } else {
                done = true;
            }
            currentStateStr = lastStateStr;
        } while (!done);
        return cycle;
    }
}

