/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.logic;

import org.encog.neural.data.NeuralData;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.logic.FeedforwardLogic;
import org.encog.neural.networks.synapse.Synapse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRecurrentLogic
extends FeedforwardLogic {
    private static final long serialVersionUID = -7477229575064477961L;
    private static final transient Logger LOGGER = LoggerFactory.getLogger(SimpleRecurrentLogic.class);

    @Override
    public void preprocessLayer(Layer layer, NeuralData input, Synapse source) {
        for (Synapse synapse : this.getNetwork().getStructure().getPreviousSynapses(layer)) {
            NeuralData recurrentInput;
            if (synapse == source) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Recurrent layer from: {}", (Object)input);
            }
            if ((recurrentInput = synapse.getFromLayer().recur()) == null) continue;
            NeuralData recurrentOutput = synapse.compute(recurrentInput);
            for (int i = 0; i < input.size(); ++i) {
                input.setData(i, input.getData(i) + recurrentOutput.getData(i));
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Recurrent layer to: {}", (Object)input);
        }
    }
}

