/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.logic;

import org.encog.neural.data.bipolar.BiPolarNeuralData;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.logic.SimpleRecurrentLogic;
import org.encog.neural.networks.synapse.Synapse;

public class ThermalLogic
extends SimpleRecurrentLogic {
    private static final long serialVersionUID = -8993932460566008196L;
    private Layer thermalLayer;
    private Synapse thermalSynapse;
    private BiPolarNeuralData currentState;

    public double calculateEnergy() {
        double tempE = 0.0;
        int neuronCount = this.getNeuronCount();
        for (int i = 0; i < neuronCount; ++i) {
            for (int j = 0; j < neuronCount; ++j) {
                if (i == j) continue;
                tempE += this.thermalSynapse.getMatrix().get(i, j) * this.currentState.getData(i) * this.currentState.getData(j);
            }
        }
        return -1.0 * tempE / 2.0;
    }

    public void clear() {
        this.thermalSynapse.getMatrix().clear();
    }

    public BiPolarNeuralData getCurrentState() {
        return this.currentState;
    }

    public int getNeuronCount() {
        return this.thermalLayer.getNeuronCount();
    }

    public Layer getThermalLayer() {
        return this.thermalLayer;
    }

    public Synapse getThermalSynapse() {
        return this.thermalSynapse;
    }

    @Override
    public void init(BasicNetwork network) {
        super.init(network);
        this.thermalLayer = this.getNetwork().getLayer("INPUT");
        this.thermalSynapse = this.getNetwork().getStructure().findSynapse(this.thermalLayer, this.thermalLayer, true);
        this.currentState = new BiPolarNeuralData(this.thermalLayer.getNeuronCount());
    }

    public void setCurrentState(BiPolarNeuralData state) {
        for (int i = 0; i < state.size(); ++i) {
            this.currentState.setData(i, state.getData(i));
        }
    }
}

