/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.structure;

import java.util.ArrayList;
import org.encog.engine.util.EngineArray;
import org.encog.engine.util.Format;
import org.encog.mathutil.NumericRange;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.synapse.Synapse;

public class AnalyzeNetwork {
    private final NumericRange weights;
    private final NumericRange bias;
    private final NumericRange weightsAndBias;
    private final int disabledConnections;
    private final int totalConnections;
    private final double[] allValues;
    private final double[] weightValues;
    private final double[] biasValues;

    public AnalyzeNetwork(BasicNetwork network) {
        int assignDisabled = 0;
        int assignedTotal = 0;
        ArrayList<Double> biasList = new ArrayList<Double>();
        ArrayList<Double> weightList = new ArrayList<Double>();
        ArrayList<Double> allList = new ArrayList<Double>();
        for (Layer layer : network.getStructure().getLayers()) {
            if (!layer.hasBias()) continue;
            for (int i = 0; i < layer.getNeuronCount(); ++i) {
                biasList.add(layer.getBiasWeight(i));
                allList.add(layer.getBiasWeight(i));
            }
        }
        for (Synapse synapse : network.getStructure().getSynapses()) {
            if (synapse.getMatrixSize() <= 0) continue;
            for (int from = 0; from < synapse.getFromNeuronCount(); ++from) {
                for (int to = 0; to < synapse.getToNeuronCount(); ++to) {
                    if (network.isConnected(synapse, from, to)) {
                        double d = synapse.getMatrix().get(from, to);
                        weightList.add(d);
                        allList.add(d);
                    } else {
                        ++assignDisabled;
                    }
                    ++assignedTotal;
                }
            }
        }
        this.disabledConnections = assignDisabled;
        this.totalConnections = assignedTotal;
        this.weights = new NumericRange(weightList);
        this.bias = new NumericRange(biasList);
        this.weightsAndBias = new NumericRange(allList);
        this.weightValues = EngineArray.listToDouble(weightList);
        this.allValues = EngineArray.listToDouble(allList);
        this.biasValues = EngineArray.listToDouble(biasList);
    }

    public double[] getAllValues() {
        return this.allValues;
    }

    public NumericRange getBias() {
        return this.bias;
    }

    public double[] getBiasValues() {
        return this.biasValues;
    }

    public int getDisabledConnections() {
        return this.disabledConnections;
    }

    public int getTotalConnections() {
        return this.totalConnections;
    }

    public NumericRange getWeights() {
        return this.weights;
    }

    public NumericRange getWeightsAndBias() {
        return this.weightsAndBias;
    }

    public double[] getWeightValues() {
        return this.weightValues;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("All Values : ");
        result.append(this.weightsAndBias.toString());
        result.append("\n");
        result.append("Bias : ");
        result.append(this.bias.toString());
        result.append("\n");
        result.append("Weights    : ");
        result.append(this.weights.toString());
        result.append("\n");
        result.append("Disabled   : ");
        result.append(Format.formatInteger(this.disabledConnections));
        result.append("\n");
        return result.toString();
    }
}

