/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.structure;

import java.util.Comparator;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.structure.CalculateDepth;
import org.encog.neural.networks.structure.NeuralStructure;

public class LayerComparator
implements Comparator<Layer> {
    private final NeuralStructure structure;
    private final CalculateDepth depth;
    private final Layer inputLayer;
    private final Layer outputLayer;

    public LayerComparator(NeuralStructure structure) {
        this.structure = structure;
        this.depth = new CalculateDepth(structure.getNetwork());
        this.inputLayer = this.structure.getNetwork().getLayer("INPUT");
        this.outputLayer = this.structure.getNetwork().getLayer("OUTPUT");
    }

    @Override
    public int compare(Layer layer1, Layer layer2) {
        int depth1 = this.depth.getDepth(layer1);
        int depth2 = this.depth.getDepth(layer2);
        if (layer1 == layer2) {
            return 0;
        }
        if (layer1 == this.outputLayer || layer2 == this.inputLayer) {
            return -1;
        }
        if (layer2 == this.outputLayer || layer1 == this.inputLayer) {
            return 1;
        }
        if (depth1 != depth2) {
            return depth1 - depth2;
        }
        return layer1.getID() - layer2.getID();
    }

    public boolean equal(Layer layer1, Layer layer2) {
        return layer1 == layer2;
    }
}

