/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.structure;

import org.encog.engine.EngineMachineLearning;
import org.encog.engine.validate.BasicMachineLearningValidate;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.layers.ContextLayer;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.layers.RadialBasisFunctionLayer;
import org.encog.neural.networks.logic.FeedforwardLogic;
import org.encog.neural.networks.logic.ThermalLogic;
import org.encog.neural.networks.synapse.Synapse;
import org.encog.neural.networks.synapse.neat.NEATSynapse;

public class ValidateForFlat
extends BasicMachineLearningValidate {
    @Override
    public String isValid(EngineMachineLearning eml) {
        if (!(eml instanceof BasicNetwork)) {
            return "Only a BasicNetwork can be converted to a flat network.";
        }
        BasicNetwork network = (BasicNetwork)eml;
        Layer inputLayer = network.getLayer("INPUT");
        Layer outputLayer = network.getLayer("OUTPUT");
        if (inputLayer == null) {
            return "To convert to a flat network, there must be an input layer.";
        }
        if (outputLayer == null) {
            return "To convert to a flat network, there must be an output layer.";
        }
        if (!(network.getLogic() instanceof FeedforwardLogic) || network.getLogic() instanceof ThermalLogic) {
            return "To convert to flat, must be using FeedforwardLogic or SimpleRecurrentLogic.";
        }
        for (Layer layer : network.getStructure().getLayers()) {
            if (layer.getNext().size() > 2) {
                return "To convert to flat a network must have at most two outbound synapses.";
            }
            if (layer.getClass() == ContextLayer.class || layer.getClass() == BasicLayer.class || layer.getClass() == RadialBasisFunctionLayer.class) continue;
            return "To convert to flat a network must have only BasicLayer and ContextLayer layers.";
        }
        for (Synapse synapse : network.getStructure().getSynapses()) {
            if (!(synapse instanceof NEATSynapse)) continue;
            return "A NEAT synapse cannot be flattened.";
        }
        return null;
    }
}

