/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.synapse;

import org.encog.mathutil.matrices.Matrix;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.synapse.BasicSynapse;
import org.encog.neural.networks.synapse.SynapseType;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.OneToOneSynapsePersistor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneToOneSynapse
extends BasicSynapse {
    private static final long serialVersionUID = -8098797476221631089L;
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public OneToOneSynapse() {
    }

    public OneToOneSynapse(Layer fromLayer, Layer toLayer) {
        if (fromLayer.getNeuronCount() != toLayer.getNeuronCount()) {
            String str = "From and to layers must have the same number of neurons.";
            if (this.logger.isErrorEnabled()) {
                this.logger.error("From and to layers must have the same number of neurons.");
            }
            throw new NeuralNetworkError("From and to layers must have the same number of neurons.");
        }
        this.setFromLayer(fromLayer);
        this.setToLayer(toLayer);
    }

    @Override
    public Object clone() {
        OneToOneSynapse result = new OneToOneSynapse(this.getFromLayer(), this.getToLayer());
        return result;
    }

    @Override
    public NeuralData compute(NeuralData input) {
        return input;
    }

    @Override
    public Persistor createPersistor() {
        return new OneToOneSynapsePersistor();
    }

    @Override
    public Matrix getMatrix() {
        return null;
    }

    @Override
    public int getMatrixSize() {
        return 0;
    }

    @Override
    public SynapseType getType() {
        return SynapseType.OneToOne;
    }

    @Override
    public boolean isTeachable() {
        return false;
    }

    @Override
    public void setMatrix(Matrix matrix) {
        throw new NeuralNetworkError("Can't set the matrix for a OneToOneSynapse");
    }
}

