/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.synapse;

import org.encog.mathutil.matrices.Matrix;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.synapse.BasicSynapse;
import org.encog.neural.networks.synapse.SynapseType;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.WeightedSynapsePersistor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightedSynapse
extends BasicSynapse {
    private static final long serialVersionUID = -1667026867054695646L;
    private Matrix matrix;
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public WeightedSynapse() {
    }

    public WeightedSynapse(Layer fromLayer, Layer toLayer) {
        this.setFromLayer(fromLayer);
        this.setToLayer(toLayer);
        this.matrix = new Matrix(this.getFromNeuronCount(), this.getToNeuronCount());
    }

    @Override
    public Object clone() {
        WeightedSynapse result = new WeightedSynapse();
        result.setMatrix(this.getMatrix().clone());
        return result;
    }

    @Override
    public NeuralData compute(NeuralData input) {
        BasicNeuralData result = new BasicNeuralData(this.getToNeuronCount());
        double[] inputArray = input.getData();
        double[][] matrixArray = this.getMatrix().getData();
        double[] resultArray = result.getData();
        for (int i = 0; i < this.getToNeuronCount(); ++i) {
            double sum = 0.0;
            for (int j = 0; j < inputArray.length; ++j) {
                sum += inputArray[j] * matrixArray[j][i];
            }
            resultArray[i] = sum;
        }
        return result;
    }

    @Override
    public Persistor createPersistor() {
        return new WeightedSynapsePersistor();
    }

    @Override
    public Matrix getMatrix() {
        return this.matrix;
    }

    @Override
    public int getMatrixSize() {
        if (this.matrix == null) {
            return 0;
        }
        return this.matrix.size();
    }

    @Override
    public SynapseType getType() {
        return SynapseType.Weighted;
    }

    @Override
    public boolean isTeachable() {
        return true;
    }

    @Override
    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
    }
}

