/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.synapse;

import org.encog.mathutil.matrices.Matrix;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.synapse.BasicSynapse;
import org.encog.neural.networks.synapse.SynapseType;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.WeightlessSynapsePersistor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightlessSynapse
extends BasicSynapse {
    private static final long serialVersionUID = -1899517385166651263L;
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public WeightlessSynapse() {
    }

    public WeightlessSynapse(Layer fromLayer, Layer toLayer) {
        this.setFromLayer(fromLayer);
        this.setToLayer(toLayer);
    }

    @Override
    public Object clone() {
        WeightlessSynapse result = new WeightlessSynapse();
        result.setMatrix(this.getMatrix().clone());
        return result;
    }

    @Override
    public NeuralData compute(NeuralData input) {
        int i;
        BasicNeuralData result = new BasicNeuralData(this.getToNeuronCount());
        double sum = 0.0;
        for (i = 0; i < input.size(); ++i) {
            sum += input.getData(i);
        }
        for (i = 0; i < this.getToNeuronCount(); ++i) {
            result.setData(i, sum);
        }
        return result;
    }

    @Override
    public Persistor createPersistor() {
        return new WeightlessSynapsePersistor();
    }

    @Override
    public Matrix getMatrix() {
        return null;
    }

    @Override
    public int getMatrixSize() {
        return 0;
    }

    @Override
    public SynapseType getType() {
        return SynapseType.Weighted;
    }

    @Override
    public boolean isTeachable() {
        return false;
    }

    @Override
    public void setMatrix(Matrix matrix) {
        String str = "Can't set the matrix for a WeightlessSynapse";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("Can't set the matrix for a WeightlessSynapse");
        }
        throw new NeuralNetworkError("Can't set the matrix for a WeightlessSynapse");
    }
}

