/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.synapse.neat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationSigmoid;
import org.encog.mathutil.matrices.Matrix;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.networks.ContextClearable;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.synapse.Synapse;
import org.encog.neural.networks.synapse.SynapseType;
import org.encog.neural.networks.synapse.neat.NEATLink;
import org.encog.neural.networks.synapse.neat.NEATNeuron;
import org.encog.neural.networks.synapse.neat.NEATNeuronType;
import org.encog.persist.EncogCollection;
import org.encog.persist.Persistor;
import org.encog.persist.annotations.EGAttribute;
import org.encog.persist.annotations.EGIgnore;
import org.encog.persist.persistors.generic.GenericPersistor;

public class NEATSynapse
implements Synapse,
ContextClearable,
Serializable {
    private static final long serialVersionUID = 3660295468309926508L;
    private ActivationFunction activationFunction;
    @EGIgnore
    private Layer fromLayer;
    @EGAttribute
    private int networkDepth;
    private final List<NEATNeuron> neurons = new ArrayList<NEATNeuron>();
    @EGAttribute
    private boolean snapshot = false;
    @EGIgnore
    private Layer toLayer;

    public NEATSynapse() {
    }

    public NEATSynapse(BasicLayer fromLayer, BasicLayer toLayer, List<NEATNeuron> neurons, ActivationFunction activationFunction, int networkDepth) {
        this.fromLayer = fromLayer;
        this.toLayer = toLayer;
        this.neurons.addAll(neurons);
        this.networkDepth = networkDepth;
        this.activationFunction = activationFunction;
    }

    public NEATSynapse(Layer fromLayer, Layer toLayer) {
        this.fromLayer = fromLayer;
        this.toLayer = toLayer;
        this.networkDepth = 0;
        this.activationFunction = new ActivationSigmoid();
    }

    @Override
    public void clearContext() {
        for (NEATNeuron neuron : this.neurons) {
            neuron.setOutput(0.0);
        }
    }

    @Override
    public Object clone() {
        return null;
    }

    @Override
    public NeuralData compute(NeuralData input) {
        BasicNeuralData result = new BasicNeuralData(this.getToNeuronCount());
        if (this.neurons.size() == 0) {
            throw new NeuralNetworkError("This network has not been evolved yet, it has no neurons in the NEAT synapse.");
        }
        int flushCount = 1;
        if (this.snapshot) {
            flushCount = this.networkDepth;
        }
        for (int i = 0; i < flushCount; ++i) {
            int outputIndex = 0;
            int index = 0;
            result.clear();
            while (this.neurons.get(index).getNeuronType() == NEATNeuronType.Input) {
                this.neurons.get(index).setOutput(input.getData(index));
                ++index;
            }
            this.neurons.get(index++).setOutput(1.0);
            while (index < this.neurons.size()) {
                NEATNeuron currentNeuron = this.neurons.get(index);
                double sum = 0.0;
                for (NEATLink link : currentNeuron.getInboundLinks()) {
                    double weight = link.getWeight();
                    double neuronOutput = link.getFromNeuron().getOutput();
                    sum += weight * neuronOutput;
                }
                double[] d = new double[]{sum / currentNeuron.getActivationResponse()};
                this.activationFunction.activationFunction(d, 0, d.length);
                this.neurons.get(index).setOutput(d[0]);
                if (currentNeuron.getNeuronType() == NEATNeuronType.Output) {
                    result.setData(outputIndex++, currentNeuron.getOutput());
                }
                ++index;
            }
        }
        return result;
    }

    @Override
    public Persistor createPersistor() {
        return new GenericPersistor(NEATSynapse.class);
    }

    public ActivationFunction getActivationFunction() {
        return this.activationFunction;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Layer getFromLayer() {
        return this.fromLayer;
    }

    @Override
    public int getFromNeuronCount() {
        return this.fromLayer.getNeuronCount();
    }

    @Override
    public Matrix getMatrix() {
        return null;
    }

    @Override
    public int getMatrixSize() {
        return 0;
    }

    @Override
    public String getName() {
        return null;
    }

    public int getNetworkDepth() {
        return this.networkDepth;
    }

    public List<NEATNeuron> getNeurons() {
        return this.neurons;
    }

    @Override
    public Layer getToLayer() {
        return this.toLayer;
    }

    @Override
    public int getToNeuronCount() {
        return this.toLayer.getNeuronCount();
    }

    @Override
    public SynapseType getType() {
        return null;
    }

    @Override
    public boolean isSelfConnected() {
        return false;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    @Override
    public boolean isTeachable() {
        return false;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
    }

    @Override
    public void setDescription(String description) {
    }

    @Override
    public void setFromLayer(Layer fromLayer) {
        this.fromLayer = fromLayer;
    }

    @Override
    public void setMatrix(Matrix matrix) {
        throw new NeuralNetworkError("Neat synapse cannot have a simple matrix.");
    }

    @Override
    public void setName(String name) {
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    @Override
    public void setToLayer(Layer toLayer) {
        this.toLayer = toLayer;
    }

    @Override
    public EncogCollection getCollection() {
        return null;
    }

    @Override
    public void setCollection(EncogCollection collection) {
    }
}

