/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training;

import java.util.ArrayList;
import java.util.List;
import org.encog.cloud.EncogCloud;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.networks.training.Strategy;
import org.encog.neural.networks.training.Train;
import org.encog.neural.networks.training.TrainingStatusUtility;
import org.encog.neural.networks.training.strategy.end.EndTrainingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicTraining
implements Train {
    private final List<Strategy> strategies = new ArrayList<Strategy>();
    private NeuralDataSet training;
    private EncogCloud cloud;
    private TrainingStatusUtility statusUtil;
    private double error;
    private int iteration;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void addStrategy(Strategy strategy) {
        strategy.init(this);
        this.strategies.add(strategy);
    }

    @Override
    public void finishTraining() {
        if (this.statusUtil != null) {
            this.statusUtil.finish();
            this.statusUtil = null;
        }
        this.getNetwork().getStructure().updateFlatNetwork();
    }

    @Override
    public EncogCloud getCloud() {
        return this.cloud;
    }

    @Override
    public double getError() {
        return this.error;
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    @Override
    public List<Strategy> getStrategies() {
        return this.strategies;
    }

    @Override
    public NeuralDataSet getTraining() {
        return this.training;
    }

    @Override
    public boolean isTrainingDone() {
        for (Strategy strategy : this.strategies) {
            EndTrainingStrategy end;
            if (!(strategy instanceof EndTrainingStrategy) || !(end = (EndTrainingStrategy)strategy).shouldStop()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void iteration(int count) {
        for (int i = 0; i < count; ++i) {
            this.iteration();
        }
    }

    public void postIteration() {
        for (Strategy strategy : this.strategies) {
            strategy.postIteration();
        }
    }

    public void preIteration() {
        ++this.iteration;
        if (this.statusUtil != null) {
            this.statusUtil.update();
        } else if (this.cloud != null) {
            this.statusUtil = new TrainingStatusUtility(this.cloud, this);
            this.statusUtil.update();
        }
        for (Strategy strategy : this.strategies) {
            strategy.preIteration();
        }
    }

    @Override
    public void setCloud(EncogCloud cloud) {
        this.cloud = cloud;
    }

    @Override
    public void setError(double error) {
        this.error = error;
    }

    @Override
    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public void setTraining(NeuralDataSet training) {
        this.training = training;
    }
}

