/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.anneal;

import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.structure.NetworkCODEC;
import org.encog.neural.networks.training.BasicTraining;
import org.encog.neural.networks.training.CalculateScore;
import org.encog.neural.networks.training.anneal.NeuralSimulatedAnnealingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeuralSimulatedAnnealing
extends BasicTraining {
    public static final double CUT = 0.5;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BasicNetwork network;
    private final NeuralSimulatedAnnealingHelper anneal;
    private final CalculateScore calculateScore;

    public NeuralSimulatedAnnealing(BasicNetwork network, CalculateScore calculateScore, double startTemp, double stopTemp, int cycles) {
        this.network = network;
        this.calculateScore = calculateScore;
        this.anneal = new NeuralSimulatedAnnealingHelper(this);
        this.anneal.setTemperature(startTemp);
        this.anneal.setStartTemperature(startTemp);
        this.anneal.setStopTemperature(stopTemp);
        this.anneal.setCycles(cycles);
    }

    @Override
    public BasicNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void iteration() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Performing Simulated Annealing iteration.");
        }
        this.preIteration();
        this.anneal.iteration();
        this.setError(this.anneal.calculateScore());
        this.postIteration();
    }

    public double[] getArray() {
        return NetworkCODEC.networkToArray(this.network);
    }

    public double[] getArrayCopy() {
        return this.getArray();
    }

    public void putArray(double[] array) {
        NetworkCODEC.arrayToNetwork(array, this.network);
    }

    public void randomize() {
        double[] array = NetworkCODEC.networkToArray(this.network);
        for (int i = 0; i < array.length; ++i) {
            double add = 0.5 - Math.random();
            add /= this.anneal.getStartTemperature();
            array[i] = array[i] + (add *= this.anneal.getTemperature());
        }
        NetworkCODEC.arrayToNetwork(array, this.network);
    }

    public CalculateScore getCalculateScore() {
        return this.calculateScore;
    }
}

