/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.competitive;

import org.encog.engine.util.BoundMath;
import org.encog.neural.data.NeuralData;
import org.encog.neural.networks.synapse.Synapse;
import org.encog.neural.networks.training.competitive.CompetitiveTraining;

public class BestMatchingUnit {
    private final CompetitiveTraining training;
    private double worstDistance;

    public BestMatchingUnit(CompetitiveTraining training) {
        this.training = training;
    }

    public int calculateBMU(Synapse synapse, NeuralData input) {
        int result = 0;
        double lowestDistance = Double.MAX_VALUE;
        for (int i = 0; i < this.training.getOutputNeuronCount(); ++i) {
            double distance = this.calculateEuclideanDistance(synapse, input, i);
            if (!(distance < lowestDistance)) continue;
            lowestDistance = distance;
            result = i;
        }
        if (lowestDistance > this.worstDistance) {
            this.worstDistance = lowestDistance;
        }
        return result;
    }

    public double calculateEuclideanDistance(Synapse synapse, NeuralData input, int outputNeuron) {
        double result = 0.0;
        for (int i = 0; i < input.size(); ++i) {
            double diff = input.getData(i) - synapse.getMatrix().get(i, outputNeuron);
            result += diff * diff;
        }
        return BoundMath.sqrt(result);
    }

    public double getWorstDistance() {
        return this.worstDistance;
    }

    public void reset() {
        this.worstDistance = Double.MIN_VALUE;
    }
}

