/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.competitive.neighborhood;

import org.encog.engine.network.rbf.RadialBasisFunction;
import org.encog.engine.util.EngineArray;
import org.encog.mathutil.rbf.GaussianFunction;
import org.encog.mathutil.rbf.InverseMultiquadricFunction;
import org.encog.mathutil.rbf.MexicanHatFunction;
import org.encog.mathutil.rbf.MultiquadricFunction;
import org.encog.mathutil.rbf.RBFEnum;
import org.encog.neural.networks.training.competitive.neighborhood.NeighborhoodFunction;

public class NeighborhoodRBF
implements NeighborhoodFunction {
    private RadialBasisFunction rbf;
    private final int[] size;
    private int[] displacement;

    public NeighborhoodRBF(RBFEnum type, int x, int y) {
        int[] size = new int[]{x, y};
        double[] centerArray = new double[]{0.0, 0.0};
        double[] widthArray = new double[]{1.0, 1.0};
        switch (type) {
            case Gaussian: {
                this.rbf = new GaussianFunction(2);
                break;
            }
            case InverseMultiquadric: {
                this.rbf = new InverseMultiquadricFunction(2);
                break;
            }
            case Multiquadric: {
                this.rbf = new MultiquadricFunction(2);
                break;
            }
            case MexicanHat: {
                this.rbf = new MexicanHatFunction(2);
            }
        }
        this.rbf.setWidth(1.0);
        EngineArray.arrayCopy(centerArray, this.rbf.getCenters());
        this.size = size;
        this.calculateDisplacement();
    }

    public NeighborhoodRBF(int[] size, RadialBasisFunction rbf) {
        this.rbf = rbf;
        this.size = size;
        this.calculateDisplacement();
    }

    private void calculateDisplacement() {
        this.displacement = new int[this.size.length];
        for (int i = 0; i < this.size.length; ++i) {
            int value = i == 0 ? 0 : (i == 1 ? this.size[0] : this.displacement[i - 1] * this.size[i - 1]);
            this.displacement[i] = value;
        }
    }

    @Override
    public double function(int currentNeuron, int bestNeuron) {
        double[] vector = new double[this.displacement.length];
        int[] vectorCurrent = this.translateCoordinates(currentNeuron);
        int[] vectorBest = this.translateCoordinates(bestNeuron);
        for (int i = 0; i < vectorCurrent.length; ++i) {
            vector[i] = vectorCurrent[i] - vectorBest[i];
        }
        return this.rbf.calculate(vector);
    }

    @Override
    public double getRadius() {
        return this.rbf.getWidth();
    }

    public RadialBasisFunction getRBF() {
        return this.rbf;
    }

    @Override
    public void setRadius(double radius) {
        this.rbf.setWidth(radius);
    }

    private int[] translateCoordinates(int index) {
        int[] result = new int[this.displacement.length];
        int countingIndex = index;
        for (int i = this.displacement.length - 1; i >= 0; --i) {
            int value = this.displacement[i] > 0 ? countingIndex / this.displacement[i] : countingIndex;
            countingIndex -= this.displacement[i] * value;
            result[i] = value;
        }
        return result;
    }
}

