/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.competitive.neighborhood;

import org.encog.engine.network.rbf.RadialBasisFunction;
import org.encog.neural.networks.training.competitive.neighborhood.NeighborhoodFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeighborhoodSingleRBF
implements NeighborhoodFunction {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RadialBasisFunction radial;

    public NeighborhoodSingleRBF(RadialBasisFunction radial) {
        this.radial = radial;
    }

    @Override
    public double function(int currentNeuron, int bestNeuron) {
        double[] d = new double[]{currentNeuron - bestNeuron};
        return this.radial.calculate(d);
    }

    @Override
    public double getRadius() {
        return this.radial.getWidth();
    }

    @Override
    public void setRadius(double radius) {
        this.radial.setWidth(radius);
    }
}

