/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.concurrent.jobs;

import java.util.ArrayList;
import java.util.List;
import org.encog.engine.network.train.prop.OpenCLTrainingProfile;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.Strategy;
import org.encog.neural.networks.training.Train;
import org.encog.neural.networks.training.strategy.end.EndTrainingStrategy;

public abstract class TrainingJob {
    private BasicNetwork network;
    private NeuralDataSet training;
    private final List<Strategy> strategies = new ArrayList<Strategy>();
    private boolean loadToMemory;
    private Train train;
    private Throwable error;
    private int iterationsPer;
    private double localRatio;
    private int globalRatio;
    private double segmentationRatio;

    public TrainingJob(BasicNetwork network, NeuralDataSet training, boolean loadToMemory) {
        this.network = network;
        this.training = training;
        this.loadToMemory = loadToMemory;
        this.iterationsPer = 1;
        this.localRatio = 1.0;
        this.globalRatio = 1;
        this.segmentationRatio = 1.0;
    }

    public abstract void createTrainer(OpenCLTrainingProfile var1, boolean var2);

    public Throwable getError() {
        return this.error;
    }

    public BasicNetwork getNetwork() {
        return this.network;
    }

    public List<Strategy> getStrategies() {
        return this.strategies;
    }

    public Train getTrain() {
        return this.train;
    }

    public NeuralDataSet getTraining() {
        return this.training;
    }

    public boolean isLoadToMemory() {
        return this.loadToMemory;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public void setLoadToMemory(boolean loadToMemory) {
        this.loadToMemory = loadToMemory;
    }

    public void setNetwork(BasicNetwork network) {
        this.network = network;
    }

    public void setTrain(Train train) {
        this.train = train;
    }

    public void setTraining(NeuralDataSet training) {
        this.training = training;
    }

    public boolean shouldContinue() {
        for (Strategy strategy : this.train.getStrategies()) {
            EndTrainingStrategy end;
            if (!(strategy instanceof EndTrainingStrategy) || !(end = (EndTrainingStrategy)strategy).shouldStop()) continue;
            return false;
        }
        return true;
    }

    public int getIterationsPer() {
        return this.iterationsPer;
    }

    public void setIterationsPer(int iterationsPer) {
        this.iterationsPer = iterationsPer;
    }

    public double getLocalRatio() {
        return this.localRatio;
    }

    public void setLocalRatio(double localRatio) {
        this.localRatio = localRatio;
    }

    public int getGlobalRatio() {
        return this.globalRatio;
    }

    public void setGlobalRatio(int globalRatio) {
        this.globalRatio = globalRatio;
    }

    public double getSegmentationRatio() {
        return this.segmentationRatio;
    }

    public void setSegmentationRatio(double segmentationRatio) {
        this.segmentationRatio = segmentationRatio;
    }
}

