/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.cpn;

import org.encog.neural.data.NeuralData;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.synapse.Synapse;
import org.encog.neural.networks.training.TrainingError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindCPN {
    private final Layer inputLayer;
    private final Layer instarLayer;
    private final Layer outstarLayer;
    private final Synapse instarSynapse;
    private final Synapse outstarSynapse;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public FindCPN(BasicNetwork network) {
        if (network.getStructure().getLayers().size() != 3) {
            String str = "A CPN network must have exactly 3 layers";
            if (this.logger.isErrorEnabled()) {
                this.logger.error("A CPN network must have exactly 3 layers");
            }
            throw new TrainingError("A CPN network must have exactly 3 layers");
        }
        this.inputLayer = network.getLayer("INPUT");
        this.outstarLayer = network.getLayer("OUTSTAR");
        this.instarLayer = network.getLayer("INSTAR");
        if (this.outstarLayer == null) {
            String str = "Can't find an OUTSTAR layer, this is required.";
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Can't find an OUTSTAR layer, this is required.");
            }
            throw new TrainingError("Can't find an OUTSTAR layer, this is required.");
        }
        if (this.instarLayer == null) {
            String str = "Can't find an OUTSTAR layer, this is required.";
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Can't find an OUTSTAR layer, this is required.");
            }
            throw new TrainingError("Can't find an OUTSTAR layer, this is required.");
        }
        this.instarSynapse = this.inputLayer.getNext().iterator().next();
        this.outstarSynapse = this.instarLayer.getNext().iterator().next();
    }

    public Layer getInputLayer() {
        return this.inputLayer;
    }

    public Layer getInstarLayer() {
        return this.instarLayer;
    }

    public Synapse getInstarSynapse() {
        return this.instarSynapse;
    }

    public Layer getOutstarLayer() {
        return this.outstarLayer;
    }

    public Synapse getOutstarSynapse() {
        return this.outstarSynapse;
    }

    public int winner(NeuralData data) {
        int winner = -1;
        for (int i = 0; i < data.size(); ++i) {
            if (winner != -1 && !(data.getData(i) > data.getData(winner))) continue;
            winner = i;
        }
        return winner;
    }
}

