/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.genetic;

import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.structure.NetworkCODEC;
import org.encog.neural.networks.training.genetic.NeuralGeneticAlgorithm;
import org.encog.solve.genetic.genes.DoubleGene;
import org.encog.solve.genetic.genome.BasicGenome;
import org.encog.solve.genetic.genome.Chromosome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeuralGenome
extends BasicGenome {
    private final Chromosome networkChromosome;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public NeuralGenome(NeuralGeneticAlgorithm nga, BasicNetwork network) {
        super(nga.getGenetic());
        this.setOrganism(network);
        this.networkChromosome = new Chromosome();
        int size = network.getStructure().calculateSize();
        for (int i = 0; i < size; ++i) {
            DoubleGene gene = new DoubleGene();
            this.networkChromosome.getGenes().add(gene);
        }
        this.getChromosomes().add(this.networkChromosome);
        this.encode();
    }

    @Override
    public void decode() {
        double[] net = new double[this.networkChromosome.getGenes().size()];
        for (int i = 0; i < net.length; ++i) {
            DoubleGene gene = (DoubleGene)this.networkChromosome.getGenes().get(i);
            net[i] = gene.getValue();
        }
        NetworkCODEC.arrayToNetwork(net, (BasicNetwork)this.getOrganism());
    }

    @Override
    public void encode() {
        double[] net = NetworkCODEC.networkToArray((BasicNetwork)this.getOrganism());
        for (int i = 0; i < net.length; ++i) {
            ((DoubleGene)this.networkChromosome.getGene(i)).setValue(net[i]);
        }
    }
}

