/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.neat;

import org.encog.persist.annotations.EGAttribute;
import org.encog.solve.genetic.genes.BasicGene;
import org.encog.solve.genetic.genes.Gene;

public class NEATLinkGene
extends BasicGene {
    @EGAttribute
    private long fromNeuronID;
    @EGAttribute
    private boolean recurrent;
    @EGAttribute
    private long toNeuronID;
    @EGAttribute
    private double weight;

    public NEATLinkGene() {
    }

    public NEATLinkGene(long fromNeuronID, long toNeuronID, boolean enabled, long innovationID, double weight, boolean recurrent) {
        this.fromNeuronID = fromNeuronID;
        this.toNeuronID = toNeuronID;
        this.setEnabled(enabled);
        this.setInnovationId(innovationID);
        this.weight = weight;
        this.recurrent = recurrent;
    }

    @Override
    public void copy(Gene gene) {
        NEATLinkGene other = (NEATLinkGene)gene;
        this.setEnabled(other.isEnabled());
        this.fromNeuronID = other.fromNeuronID;
        this.toNeuronID = other.toNeuronID;
        this.setInnovationId(other.getInnovationId());
        this.recurrent = other.recurrent;
        this.weight = other.weight;
    }

    public long getFromNeuronID() {
        return this.fromNeuronID;
    }

    public long getToNeuronID() {
        return this.toNeuronID;
    }

    public double getWeight() {
        return this.weight;
    }

    public boolean isRecurrent() {
        return this.recurrent;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[NEATLinkGene:innov=");
        result.append(this.getInnovationId());
        result.append(",enabled=");
        result.append(this.isEnabled());
        result.append(",from=");
        result.append(this.fromNeuronID);
        result.append(",to=");
        result.append(this.toNeuronID);
        result.append("]");
        return result.toString();
    }
}

