/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.propagation.back;

import org.encog.engine.network.train.prop.OpenCLTrainingProfile;
import org.encog.engine.network.train.prop.TrainFlatNetworkBackPropagation;
import org.encog.engine.network.train.prop.TrainFlatNetworkOpenCL;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.LearningRate;
import org.encog.neural.networks.training.Momentum;
import org.encog.neural.networks.training.TrainingError;
import org.encog.neural.networks.training.propagation.Propagation;
import org.encog.neural.networks.training.propagation.TrainingContinuation;
import org.encog.neural.networks.training.strategy.SmartLearningRate;
import org.encog.neural.networks.training.strategy.SmartMomentum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Backpropagation
extends Propagation
implements Momentum,
LearningRate {
    public static final String LAST_DELTA = "LAST_DELTA";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Backpropagation(BasicNetwork network, NeuralDataSet training) {
        this(network, training, null, 0.0, 0.0);
        this.addStrategy(new SmartLearningRate());
        this.addStrategy(new SmartMomentum());
    }

    public Backpropagation(BasicNetwork network, NeuralDataSet training, double learnRate, double momentum) {
        this(network, training, null, learnRate, momentum);
    }

    public Backpropagation(BasicNetwork network, NeuralDataSet training, OpenCLTrainingProfile profile, double learnRate, double momentum) {
        super(network, training);
        if (profile == null) {
            TrainFlatNetworkBackPropagation backFlat = new TrainFlatNetworkBackPropagation(network.getStructure().getFlat(), this.getTraining(), learnRate, momentum);
            this.setFlatTraining(backFlat);
        } else {
            TrainFlatNetworkOpenCL rpropFlat = new TrainFlatNetworkOpenCL(network.getStructure().getFlat(), this.getTraining(), profile);
            rpropFlat.learnBPROP(learnRate, momentum);
            this.setFlatTraining(rpropFlat);
        }
    }

    public double[] getLastDelta() {
        return ((TrainFlatNetworkBackPropagation)this.getFlatTraining()).getLastDelta();
    }

    @Override
    public double getLearningRate() {
        return ((TrainFlatNetworkBackPropagation)this.getFlatTraining()).getLearningRate();
    }

    @Override
    public double getMomentum() {
        return ((TrainFlatNetworkBackPropagation)this.getFlatTraining()).getMomentum();
    }

    @Override
    public boolean isValidResume(TrainingContinuation state) {
        if (!state.getContents().containsKey(LAST_DELTA)) {
            return false;
        }
        double[] d = (double[])state.get(LAST_DELTA);
        return d.length == this.getNetwork().getStructure().calculateSize();
    }

    @Override
    public TrainingContinuation pause() {
        TrainingContinuation result = new TrainingContinuation();
        TrainFlatNetworkBackPropagation backFlat = (TrainFlatNetworkBackPropagation)this.getFlatTraining();
        double[] d = backFlat.getLastDelta();
        result.set(LAST_DELTA, d);
        return result;
    }

    @Override
    public void resume(TrainingContinuation state) {
        if (!this.isValidResume(state)) {
            throw new TrainingError("Invalid training resume data length");
        }
        ((TrainFlatNetworkBackPropagation)this.getFlatTraining()).setLastDelta((double[])state.get(LAST_DELTA));
    }

    @Override
    public void setLearningRate(double rate) {
        ((TrainFlatNetworkBackPropagation)this.getFlatTraining()).setLearningRate(rate);
    }

    @Override
    public void setMomentum(double m) {
        ((TrainFlatNetworkBackPropagation)this.getFlatTraining()).setLearningRate(m);
    }
}

