/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.simple;

import org.encog.engine.util.ErrorCalculation;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.structure.FlatUpdateNeeded;
import org.encog.neural.networks.synapse.Synapse;
import org.encog.neural.networks.training.BasicTraining;
import org.encog.neural.networks.training.LearningRate;

public class TrainAdaline
extends BasicTraining
implements LearningRate {
    private final BasicNetwork network;
    private final Synapse synapse;
    private final NeuralDataSet training;
    private double learningRate;

    public TrainAdaline(BasicNetwork network, NeuralDataSet training, double learningRate) {
        if (network.getStructure().getLayers().size() > 2) {
            throw new NeuralNetworkError("An ADALINE network only has two layers.");
        }
        this.network = network;
        Layer input = network.getLayer("INPUT");
        this.synapse = input.getNext().get(0);
        this.training = training;
        this.learningRate = learningRate;
    }

    @Override
    public double getLearningRate() {
        return this.learningRate;
    }

    @Override
    public BasicNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void iteration() {
        ErrorCalculation errorCalculation = new ErrorCalculation();
        Layer inputLayer = this.network.getLayer("INPUT");
        Layer outputLayer = this.network.getLayer("OUTPUT");
        for (NeuralDataPair pair : this.training) {
            NeuralData output = this.network.compute(pair.getInput());
            for (int currentAdaline = 0; currentAdaline < output.size(); ++currentAdaline) {
                double diff = pair.getIdeal().getData(currentAdaline) - output.getData(currentAdaline);
                for (int i = 0; i < inputLayer.getNeuronCount(); ++i) {
                    double input = pair.getInput().getData(i);
                    this.synapse.getMatrix().add(i, currentAdaline, this.learningRate * diff * input);
                }
                double t = outputLayer.getBiasWeight(currentAdaline);
                outputLayer.setBiasWeight(currentAdaline, t += this.learningRate * diff);
            }
            this.network.getStructure().setFlatUpdate(FlatUpdateNeeded.Flatten);
            errorCalculation.updateError(output.getData(), pair.getIdeal().getData());
        }
        this.setError(errorCalculation.calculate());
    }

    @Override
    public void setLearningRate(double rate) {
        this.learningRate = rate;
    }
}

