/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.strategy;

import org.encog.neural.data.Indexable;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.networks.training.LearningRate;
import org.encog.neural.networks.training.Strategy;
import org.encog.neural.networks.training.Train;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartLearningRate
implements Strategy {
    public static final double LEARNING_DECAY = 0.99;
    private Train train;
    private LearningRate setter;
    private double currentLearningRate;
    private long trainingSize;
    private double lastError;
    private boolean ready;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private long determineTrainingSize() {
        long result = 0L;
        if (this.train instanceof Indexable) {
            result = ((Indexable)((Object)this)).getRecordCount();
        } else {
            for (NeuralDataPair pair : this.train.getTraining()) {
                ++result;
            }
        }
        return result;
    }

    @Override
    public void init(Train train) {
        this.train = train;
        this.ready = false;
        this.setter = (LearningRate)((Object)train);
        this.trainingSize = this.determineTrainingSize();
        this.currentLearningRate = 1.0 / (double)this.trainingSize;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Starting learning rate: {}", (Object)this.currentLearningRate);
        }
        this.setter.setLearningRate(this.currentLearningRate);
    }

    @Override
    public void postIteration() {
        if (this.ready) {
            if (this.train.getError() > this.lastError) {
                this.currentLearningRate *= 0.99;
                this.setter.setLearningRate(this.currentLearningRate);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Adjusting learning rate to {}", (Object)this.currentLearningRate);
                }
            }
        } else {
            this.ready = true;
        }
    }

    @Override
    public void preIteration() {
        this.lastError = this.train.getError();
    }
}

