/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.strategy.end;

import java.util.concurrent.atomic.AtomicInteger;
import org.encog.neural.networks.training.Train;
import org.encog.neural.networks.training.strategy.end.EndTrainingStrategy;

public class EndMinutesStrategy
implements EndTrainingStrategy {
    private final int minutes;
    private long startedTime;
    private boolean started;
    private final AtomicInteger minutesLeft = new AtomicInteger(0);

    public EndMinutesStrategy(int minutes) {
        this.minutes = minutes;
        this.started = false;
        this.minutesLeft.set(minutes);
    }

    @Override
    public boolean shouldStop() {
        return this.started && this.minutesLeft.get() >= 0;
    }

    @Override
    public void init(Train train) {
        this.started = true;
        this.startedTime = System.currentTimeMillis();
    }

    @Override
    public void postIteration() {
        long now = System.currentTimeMillis();
        this.minutesLeft.set((int)((now - this.startedTime) / 60000L));
    }

    @Override
    public void preIteration() {
    }

    public int getMinutesLeft() {
        return this.minutesLeft.get();
    }

    public int getMinutes() {
        return this.minutes;
    }
}

