/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import java.util.ArrayList;
import java.util.List;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedForwardPattern
implements NeuralNetworkPattern {
    private int inputNeurons;
    private int outputNeurons;
    private ActivationFunction activation;
    private final List<Integer> hidden = new ArrayList<Integer>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void addHiddenLayer(int count) {
        this.hidden.add(count);
    }

    @Override
    public void clear() {
        this.hidden.clear();
    }

    @Override
    public BasicNetwork generate() {
        int y = 50;
        BasicLayer input = new BasicLayer(this.activation, false, this.inputNeurons);
        BasicNetwork result = new BasicNetwork();
        result.addLayer(input);
        input.setX(50);
        input.setY(y);
        y += 150;
        for (Integer count : this.hidden) {
            BasicLayer hidden = new BasicLayer(this.activation, true, count);
            result.addLayer(hidden);
            hidden.setX(50);
            hidden.setY(y);
            y += 150;
        }
        BasicLayer output = new BasicLayer(this.activation, true, this.outputNeurons);
        result.addLayer(output);
        output.setX(50);
        output.setY(y);
        y += 150;
        result.getStructure().finalizeStructure();
        result.reset();
        return result;
    }

    @Override
    public void setActivationFunction(ActivationFunction activation) {
        this.activation = activation;
    }

    @Override
    public void setInputNeurons(int count) {
        this.inputNeurons = count;
    }

    @Override
    public void setOutputNeurons(int count) {
        this.outputNeurons = count;
    }
}

