/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.layers.ContextLayer;
import org.encog.neural.networks.synapse.SynapseType;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JordanPattern
implements NeuralNetworkPattern {
    private int inputNeurons = -1;
    private int outputNeurons = -1;
    private int hiddenNeurons = -1;
    private ActivationFunction activation;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void addHiddenLayer(int count) {
        if (this.hiddenNeurons != -1) {
            String str = "A Jordan neural network should have only one hidden layer.";
            if (this.logger.isErrorEnabled()) {
                this.logger.error("A Jordan neural network should have only one hidden layer.");
            }
            throw new PatternError("A Jordan neural network should have only one hidden layer.");
        }
        this.hiddenNeurons = count;
    }

    @Override
    public void clear() {
        this.hiddenNeurons = -1;
    }

    @Override
    public BasicNetwork generate() {
        BasicLayer input = new BasicLayer(this.activation, false, this.inputNeurons);
        BasicLayer hidden = new BasicLayer(this.activation, true, this.hiddenNeurons);
        BasicLayer output = new BasicLayer(this.activation, true, this.outputNeurons);
        ContextLayer context = new ContextLayer(this.outputNeurons);
        BasicNetwork network = new BasicNetwork();
        network.addLayer(input);
        network.addLayer(hidden);
        network.addLayer(output);
        output.addNext(context, SynapseType.OneToOne);
        context.addNext(hidden);
        int y = 50;
        input.setX(50);
        input.setY(y);
        hidden.setX(50);
        hidden.setY(y += 150);
        context.setX(300);
        context.setY(y);
        output.setX(50);
        output.setY(y += 150);
        network.getStructure().finalizeStructure();
        network.reset();
        return network;
    }

    @Override
    public void setActivationFunction(ActivationFunction activation) {
        this.activation = activation;
    }

    @Override
    public void setInputNeurons(int count) {
        this.inputNeurons = count;
    }

    @Override
    public void setOutputNeurons(int count) {
        this.outputNeurons = count;
    }
}

