/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import java.util.ArrayList;
import java.util.List;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.synapse.neat.NEATNeuron;
import org.encog.neural.networks.synapse.neat.NEATSynapse;
import org.encog.neural.pattern.NeuralNetworkPattern;

public class NEATPattern
implements NeuralNetworkPattern {
    private int inputNeurons = -1;
    private int outputNeurons = -1;
    private ActivationFunction neatActivation;
    private ActivationFunction outputActivation;
    private boolean snapshot;
    private final List<NEATNeuron> neurons = new ArrayList<NEATNeuron>();

    @Override
    public void addHiddenLayer(int count) {
        throw new NeuralNetworkError("A NEAT network will evolve its hidden layers, do not specify any.");
    }

    @Override
    public void clear() {
    }

    @Override
    public BasicNetwork generate() {
        int y = 50;
        BasicLayer inputLayer = new BasicLayer(new ActivationLinear(), false, this.inputNeurons);
        inputLayer.setX(50);
        inputLayer.setY(y);
        BasicLayer outputLayer = new BasicLayer(this.outputActivation, false, this.outputNeurons);
        outputLayer.setX(50);
        outputLayer.setY(y += 150);
        NEATSynapse synapse = new NEATSynapse(inputLayer, outputLayer, this.neurons, this.neatActivation, 0);
        synapse.setSnapshot(this.snapshot);
        inputLayer.addSynapse(synapse);
        BasicNetwork network = new BasicNetwork();
        network.tagLayer("INPUT", inputLayer);
        network.tagLayer("OUTPUT", outputLayer);
        network.getStructure().finalizeStructure();
        return network;
    }

    @Override
    public void setActivationFunction(ActivationFunction activation) {
        this.outputActivation = activation;
    }

    public void setNEATActivationFunction(ActivationFunction activation) {
        this.neatActivation = activation;
    }

    @Override
    public void setInputNeurons(int count) {
        this.inputNeurons = count;
    }

    @Override
    public void setOutputNeurons(int count) {
        this.outputNeurons = count;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    public List<NEATNeuron> getNeurons() {
        return this.neurons;
    }
}

