/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.logic.SOMLogic;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOMPattern
implements NeuralNetworkPattern {
    private int inputNeurons;
    private int outputNeurons;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void addHiddenLayer(int count) {
        String str = "A SOM network does not have hidden layers.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A SOM network does not have hidden layers.");
        }
        throw new PatternError("A SOM network does not have hidden layers.");
    }

    @Override
    public void clear() {
    }

    @Override
    public BasicNetwork generate() {
        BasicLayer input = new BasicLayer(new ActivationLinear(), false, this.inputNeurons);
        BasicLayer output = new BasicLayer(new ActivationLinear(), false, this.outputNeurons);
        int y = 50;
        BasicNetwork network = new BasicNetwork(new SOMLogic());
        network.addLayer(input);
        network.addLayer(output);
        input.setX(50);
        output.setX(50);
        input.setY(y);
        output.setY(y += 150);
        network.getStructure().finalizeStructure();
        network.reset();
        return network;
    }

    @Override
    public void setActivationFunction(ActivationFunction activation) {
        String str = "A SOM network can't define an activation function.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A SOM network can't define an activation function.");
        }
        throw new PatternError("A SOM network can't define an activation function.");
    }

    @Override
    public void setInputNeurons(int count) {
        this.inputNeurons = count;
    }

    @Override
    public void setOutputNeurons(int count) {
        this.outputNeurons = count;
    }
}

